/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtPrim;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.typo.KtTypoAssignPrim;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;
import java.util.Vector;

public class KtPatternsPrim
extends KtTypoAssignPrim {
    private static final char WORD_BOUNDARY = '\u0000';

    public KtPatternsPrim(String name) {
        super(name);
    }

    @Override
    protected void assign(KtToken src, boolean glob) {
        KtTypoCommand.KtConfig cfg = KtPatternsPrim.getTypoConfig();
        if (!cfg.patternsAllowed()) {
            if (KtPatternsPrim.getConfig().formatLoaded()) {
                KtPatternsPrim.error("CantLoadPatterns");
                while (!KtPatternsPrim.nextRawToken().matchRightBrace()) {
                }
            } else {
                KtPatternsPrim.error("LatePatterns", this);
                KtPrim.scanTokenList(src, false);
            }
            return;
        }
        KtPatternsPrim.scanLeftBrace();
        StringBuilder buf = new StringBuilder();
        Vector<Integer> valBuf = new Vector<Integer>();
        boolean digitExpected = true;
        while (true) {
            KtCharCode toAdd;
            KtToken tok;
            KtCommand cmd;
            KtCharCode code;
            if ((code = (cmd = KtPatternsPrim.meaningOf(tok = KtPatternsPrim.nextExpToken())).charCode()) != KtCharCode.NULL && (toAdd = cmd.charCodeToAdd()) != KtCharCode.NULL && code.match(toAdd)) {
                char letter;
                char chr = code.toChar();
                if (digitExpected && chr >= '0' && chr <= '9') {
                    int index = buf.length();
                    if (index >= valBuf.size()) {
                        valBuf.setSize(index + 1);
                    }
                    valBuf.set(index, chr - 48);
                    digitExpected = false;
                    continue;
                }
                if (code.match('.')) {
                    letter = '\u0000';
                } else {
                    letter = code.toCanonicalLetter();
                    if (letter == '\uffff') {
                        KtPatternsPrim.error("NonLetter");
                        letter = '\u0000';
                    }
                }
                buf.append(letter);
                digitExpected = true;
                continue;
            }
            if (cmd.isSpacer() || cmd.isRightBrace()) {
                int size = buf.length();
                if (size > 0) {
                    int[] values = new int[valBuf.size()];
                    for (int i = 0; i < values.length; ++i) {
                        Integer val = (Integer)valBuf.get(i);
                        values[i] = val != null ? val : 0;
                    }
                    if (values.length > 0) {
                        if (buf.charAt(0) == '\u0000') {
                            values[0] = 0;
                        }
                        if (buf.charAt(size - 1) == '\u0000' && values.length > size) {
                            values[size] = 0;
                        }
                    }
                    if (!cfg.getLanguage().setHyphPattern(buf.toString(), values)) {
                        KtPatternsPrim.error("DupPattern");
                    }
                    buf.setLength(0);
                    valBuf.clear();
                }
                if (cmd.isRightBrace()) break;
                digitExpected = true;
                continue;
            }
            KtPatternsPrim.error("BadPatterns", this);
        }
    }
}

