/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyException;
import java.security.PrivateKey;
import net.jsign.PVK;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.jsign.bouncycastle.jce.provider.BouncyCastleProvider;
import net.jsign.bouncycastle.openssl.PEMDecryptorProvider;
import net.jsign.bouncycastle.openssl.PEMEncryptedKeyPair;
import net.jsign.bouncycastle.openssl.PEMKeyPair;
import net.jsign.bouncycastle.openssl.PEMParser;
import net.jsign.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import net.jsign.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import net.jsign.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import net.jsign.bouncycastle.operator.InputDecryptorProvider;
import net.jsign.bouncycastle.operator.OperatorCreationException;
import net.jsign.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import net.jsign.bouncycastle.pkcs.PKCSException;

public class PrivateKeyUtils {
    private PrivateKeyUtils() {
    }

    public static PrivateKey load(File file, String password) throws KeyException {
        try {
            if (file.getName().endsWith(".pvk")) {
                return PVK.parse(file, password);
            }
            if (file.getName().endsWith(".pem")) {
                return PrivateKeyUtils.readPrivateKeyPEM(file, password);
            }
        }
        catch (Exception e) {
            throw new KeyException("Failed to load the private key from " + file, e);
        }
        throw new IllegalArgumentException("Unsupported private key format (PEM or PVK file expected");
    }

    private static PrivateKey readPrivateKeyPEM(File file, String password) throws IOException, OperatorCreationException, PKCSException {
        Throwable throwable = null;
        try (FileReader reader = new FileReader(file);){
            PEMParser parser = new PEMParser(reader);
            Object object = parser.readObject();
            if (object instanceof ASN1ObjectIdentifier) {
                object = parser.readObject();
            }
            if (object == null) {
                throw new IllegalArgumentException("No key found in " + file);
            }
            BouncyCastleProvider provider = new BouncyCastleProvider();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(provider);
            if (object instanceof PEMEncryptedKeyPair) {
                PEMDecryptorProvider decryptionProvider = new JcePEMDecryptorProviderBuilder().setProvider(provider).build(password.toCharArray());
                PEMKeyPair keypair = ((PEMEncryptedKeyPair)object).decryptKeyPair(decryptionProvider);
                PrivateKey privateKey = converter.getPrivateKey(keypair.getPrivateKeyInfo());
                return privateKey;
            }
            if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                InputDecryptorProvider decryptionProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider(provider).build(password.toCharArray());
                PrivateKeyInfo info = ((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo(decryptionProvider);
                PrivateKey privateKey = converter.getPrivateKey(info);
                return privateKey;
            }
            if (object instanceof PEMKeyPair) {
                PrivateKey privateKey = converter.getKeyPair((PEMKeyPair)object).getPrivate();
                return privateKey;
            }
            if (object instanceof PrivateKeyInfo) {
                PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
                return privateKey;
            }
            try {
                throw new UnsupportedOperationException("Unsupported PEM object: " + object.getClass().getSimpleName());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

