/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.cms.jcajce;

import java.security.PublicKey;
import net.jsign.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import net.jsign.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import net.jsign.bouncycastle.cms.SignerInformationVerifier;
import net.jsign.bouncycastle.operator.ContentVerifierProvider;
import net.jsign.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import net.jsign.bouncycastle.operator.DigestCalculatorProvider;
import net.jsign.bouncycastle.operator.OperatorCreationException;
import net.jsign.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import net.jsign.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class JcaSignerInfoVerifierBuilder {
    private Helper helper = new Helper();
    private DigestCalculatorProvider digestProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen = new DefaultCMSSignatureAlgorithmNameGenerator();
    private SignatureAlgorithmIdentifierFinder sigAlgIDFinder = new DefaultSignatureAlgorithmIdentifierFinder();

    public JcaSignerInfoVerifierBuilder(DigestCalculatorProvider digestCalculatorProvider) {
        this.digestProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(PublicKey publicKey) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIDFinder, this.helper.createContentVerifierProvider(publicKey), this.digestProvider);
    }

    private class Helper {
        private Helper() {
        }

        ContentVerifierProvider createContentVerifierProvider(PublicKey publicKey) throws OperatorCreationException {
            return new JcaContentVerifierProviderBuilder().build(publicKey);
        }
    }
}

