/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.pkcs;

import java.io.IOException;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.pkcs.Attribute;
import net.jsign.bouncycastle.asn1.pkcs.CertificationRequest;
import net.jsign.bouncycastle.pkcs.PKCSIOException;

public class PKCS10CertificationRequest {
    private static Attribute[] EMPTY_ARRAY = new Attribute[0];
    private CertificationRequest certificationRequest;

    private static CertificationRequest parseBytes(byte[] byArray) throws IOException {
        try {
            CertificationRequest certificationRequest = CertificationRequest.getInstance(ASN1Primitive.fromByteArray(byArray));
            if (certificationRequest == null) {
                throw new PKCSIOException("empty data passed to constructor");
            }
            return certificationRequest;
        }
        catch (ClassCastException classCastException) {
            throw new PKCSIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PKCSIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public PKCS10CertificationRequest(CertificationRequest certificationRequest) {
        if (certificationRequest == null) {
            throw new NullPointerException("certificationRequest cannot be null");
        }
        this.certificationRequest = certificationRequest;
    }

    public PKCS10CertificationRequest(byte[] byArray) throws IOException {
        this(PKCS10CertificationRequest.parseBytes(byArray));
    }

    public CertificationRequest toASN1Structure() {
        return this.certificationRequest;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PKCS10CertificationRequest)) {
            return false;
        }
        PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)object;
        return this.toASN1Structure().equals(pKCS10CertificationRequest.toASN1Structure());
    }

    public int hashCode() {
        return this.toASN1Structure().hashCode();
    }
}

