/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.builder;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxLeaders;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtLanguage;
import com.whitemagicsoftware.keentype.node.KtLeaders;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtPenaltyNode;

public abstract class KtBuilder
implements KtLoggable {
    public static final KtBuilder NULL;
    private static KtBuilder topBuilder;
    protected KtBuilder enclosing = NULL;
    private final Object mMutex = new Object();

    public boolean isHorizontal() {
        return false;
    }

    public boolean isVertical() {
        return false;
    }

    public boolean isMath() {
        return false;
    }

    public boolean isInner() {
        return false;
    }

    public boolean isCharAllowed() {
        return false;
    }

    public boolean wantsMigrations() {
        return false;
    }

    public boolean willBeBroken() {
        return false;
    }

    public boolean forbidsThirdPartOfDiscretionary() {
        return false;
    }

    public abstract void addNode(KtNode var1);

    public abstract void addNodes(KtNodeEnum var1);

    public abstract void addKern(KtDimen var1);

    public abstract void addSkip(KtGlue var1);

    public abstract void addNamedSkip(KtGlue var1, String var2);

    public abstract void addRule(KtBoxSizes var1);

    public abstract void addLeaders(KtGlue var1, KtLeaders var2);

    public abstract void addLeadRule(KtGlue var1, KtBoxSizes var2, String var3);

    public void addSkip(KtGlue skip, String name) {
        if (name != null) {
            this.addNamedSkip(skip, name);
        } else {
            this.addSkip(skip);
        }
    }

    public void addPenalty(KtNum pen) {
        this.addNode(new KtPenaltyNode(pen));
    }

    public void addBox(KtNode box) {
        this.addNode(box);
    }

    public boolean unBox(KtBox box) {
        return false;
    }

    public KtBoxLeaders.KtMover getBoxLeadMover() {
        return KtBoxLeaders.NULL_MOVER;
    }

    public int getStartLine() {
        return 0;
    }

    public int getSpaceFactor() {
        return 0;
    }

    public void setSpaceFactor(int sf) {
    }

    public void resetSpaceFactor() {
    }

    public void adjustSpaceFactor(int sf) {
        throw new RuntimeException("char not allowed");
    }

    public KtDimen getPrevDepth() {
        return KtDimen.NULL;
    }

    public void setPrevDepth(KtDimen pd) {
    }

    public void buildPage() {
    }

    public KtNodeList getParagraph() {
        return KtNodeList.NULL;
    }

    public boolean needsParSkip() {
        return false;
    }

    public boolean canTakeLastNode() {
        return true;
    }

    public boolean canTakeLastBox() {
        return this.canTakeLastNode();
    }

    public KtLanguage getInitLang() {
        return KtLanguage.NULL;
    }

    public KtLanguage getCurrLang() {
        return KtLanguage.NULL;
    }

    public void setCurrLang(KtLanguage lang) {
    }

    public abstract boolean isEmpty();

    public abstract KtNode lastNode();

    public abstract void removeLastNode();

    public abstract KtNode lastSpecialNode();

    public void show(KtLog log, int depth, int breadth) {
        log.startLine().add("### ");
        this.addOn(log);
        log.add(" entered at line ").add(this.getStartLine());
        this.specialShow(log, depth, breadth);
    }

    protected void specialShow(KtLog log, int depth, int breadth) {
    }

    @Override
    public void addOn(KtLog log) {
        log.add(this.modeName()).add(" mode");
    }

    public abstract String modeName();

    public static KtBuilder top() {
        return topBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void push(KtBuilder b) {
        Object object = b.mMutex;
        synchronized (object) {
            if (b.enclosing != NULL) {
                throw new RuntimeException("builder already pushed");
            }
            b.enclosing = topBuilder;
            topBuilder = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KtBuilder pop() {
        KtBuilder b = topBuilder;
        if (b != NULL) {
            Object object = b.mMutex;
            synchronized (object) {
                topBuilder = b.enclosing;
                b.enclosing = NULL;
            }
        }
        return b;
    }

    public static void showStack(KtLog log, int depth, int breadth) {
        KtBuilder b = topBuilder;
        while (b != NULL) {
            b.show(log, depth, breadth);
            b = b.enclosing;
        }
    }

    public int getPrevGraf() {
        return this.enclosing != NULL ? this.enclosing.getPrevGraf() : 0;
    }

    public void setPrevGraf(int pg) {
        if (this.enclosing != NULL) {
            this.enclosing.setPrevGraf(pg);
        }
    }

    public int nearestValidSpaceFactor() {
        return this.enclosing != NULL ? this.enclosing.getSpaceFactor() : 0;
    }

    public KtDimen nearestValidPrevDepth() {
        return this.enclosing != NULL ? this.enclosing.getPrevDepth() : KtDimen.NULL;
    }

    static {
        topBuilder = NULL = null;
    }
}

