/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtPrimitive;
import com.whitemagicsoftware.keentype.command.KtScanToksChecker;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;

public abstract class KtPrim
extends KtCommand
implements KtPrimitive {
    private final String name;
    public static final int ADVANCE = 0;
    public static final int MULTIPLY = 1;
    public static final int DIVIDE = 2;
    public static final int INTP_MAX_REG_CODE = KtPrim.newIntParam();
    public static final int INTP_MAX_FILE_CODE = KtPrim.newIntParam();
    public static final int INTP_MAX_CHAR_CODE = KtPrim.newIntParam();

    protected KtPrim(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final KtCommand getCommand() {
        return this;
    }

    @Override
    public final void addOn(KtLog log) {
        log.addEsc(this.name);
    }

    public final String toString() {
        return "@" + this.name;
    }

    protected static KtNum performFor(KtNum val, int operation) {
        KtPrim.scanKeyword("by");
        int i = KtPrim.scanInt();
        try {
            switch (operation) {
                case 0: {
                    val = val.plus(i);
                    break;
                }
                case 1: {
                    val = val.times(i);
                    break;
                }
                case 2: {
                    val = val.over(i);
                }
            }
        }
        catch (ArithmeticException e) {
            val = KtNum.ZERO;
            KtPrim.error("ArithOverflow");
        }
        return val;
    }

    protected static KtDimen performFor(KtDimen val, int operation) {
        KtPrim.scanKeyword("by");
        try {
            switch (operation) {
                case 0: {
                    val = val.plus(KtPrim.scanDimen());
                    break;
                }
                case 1: {
                    val = val.times(KtPrim.scanInt());
                    break;
                }
                case 2: {
                    val = val.over(KtPrim.scanInt());
                }
            }
        }
        catch (ArithmeticException e) {
            val = KtDimen.ZERO;
            KtPrim.error("ArithOverflow");
        }
        return val;
    }

    protected static KtGlue performFor(KtGlue val, int operation, boolean mu) {
        KtPrim.scanKeyword("by");
        try {
            switch (operation) {
                case 0: {
                    val = val.plus(KtPrim.scanGlue(mu));
                    break;
                }
                case 1: {
                    val = val.times(KtPrim.scanInt());
                    break;
                }
                case 2: {
                    val = val.over(KtPrim.scanInt());
                }
            }
        }
        catch (ArithmeticException e) {
            val = KtGlue.ZERO;
            KtPrim.error("ArithOverflow");
        }
        return val;
    }

    public static int scanAnyCode(int par, String err) {
        int max = KtPrim.getConfig().getIntParam(par);
        int i = KtPrim.scanInt();
        if (i < 0 || i > max) {
            KtPrim.error(err, KtPrim.num(i), KtPrim.num(0), KtPrim.num(max));
            return 0;
        }
        return i;
    }

    public static int scanRegisterCode() {
        return KtPrim.scanAnyCode(INTP_MAX_REG_CODE, "BadRegister");
    }

    public static int scanFileCode() {
        return KtPrim.scanAnyCode(INTP_MAX_FILE_CODE, "BadFileNum");
    }

    public static int scanCharacterCode() {
        return KtPrim.scanAnyCode(INTP_MAX_CHAR_CODE, "BadCharCode");
    }

    public static KtTokenList scanTokenList(KtLoggable src, boolean xpand) {
        KtTokenList.KtBuffer buf = new KtTokenList.KtBuffer(30);
        KtInpTokChecker savedChk = KtPrim.setTokenChecker(new KtScanToksChecker("OuterInToks", "EOFinToks", "text", buf, src));
        KtPrim.scanLeftBrace();
        int balance = 1;
        while (true) {
            KtToken tok;
            if ((tok = KtPrim.nextScannedToken(xpand, buf)) == KtToken.NULL) {
                continue;
            }
            if (tok.matchLeftBrace()) {
                ++balance;
            } else if (tok.matchRightBrace() && --balance == 0) break;
            buf.append(tok);
        }
        KtPrim.setTokenChecker(savedChk);
        return buf.toTokenList();
    }

    public static KtToken nextScannedToken(boolean xpand, KtTokenList.KtBuffer buf) {
        return xpand ? KtPrim.nextExpToken(buf) : KtPrim.nextRawToken();
    }
}

