/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.math;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.command.KtActiveCharToken;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtPrim;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.math.KtMathAction;
import com.whitemagicsoftware.keentype.math.KtMathBuilder;
import com.whitemagicsoftware.keentype.math.KtMathGroup;
import com.whitemagicsoftware.keentype.math.KtMathShiftToken;
import com.whitemagicsoftware.keentype.noad.KtCharField;
import com.whitemagicsoftware.keentype.noad.KtDelimiter;
import com.whitemagicsoftware.keentype.noad.KtEmptyField;
import com.whitemagicsoftware.keentype.noad.KtField;
import com.whitemagicsoftware.keentype.noad.KtNoad;
import com.whitemagicsoftware.keentype.noad.KtOrdNoad;
import com.whitemagicsoftware.keentype.noad.KtTreatField;
import com.whitemagicsoftware.keentype.node.KtChrKernNode;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.typo.KtAction;
import com.whitemagicsoftware.keentype.typo.KtBuilderPrim;
import com.whitemagicsoftware.keentype.typo.KtCharHandler;

public abstract class KtMathPrim
extends KtBuilderPrim {
    private static KtConfig config;
    public static final int INTP_MAX_MATH_CODE;
    public static final int INTP_MAX_DEL_CODE;
    public static final KtAction DOLLAR;
    public static final KtAction ZERO_KERN;
    public static final KtMathAction LEFT_BRACE;

    public KtMathPrim(String name) {
        super(name);
    }

    public abstract KtMathAction mathAction();

    public static void setMathConfig(KtConfig conf) {
        config = conf;
    }

    public static KtConfig getMathConfig() {
        return config;
    }

    public static int scanMathCharCode() {
        return KtPrim.scanAnyCode(INTP_MAX_MATH_CODE, "BadMathCharCode");
    }

    public static int scanDelimiterCode() {
        return KtPrim.scanAnyCode(INTP_MAX_DEL_CODE, "BadDelimiterCode");
    }

    public static void setMathChar(KtMathBuilder bld, KtCharCode code) {
        KtNoad noad = KtMathPrim.getMathConfig().noadForCode(code.mathCode());
        if (noad != KtNoad.NULL) {
            bld.addNoad(noad);
        } else {
            KtMathPrim.backActiveChar(code);
        }
    }

    public static void setMathChar(KtMathBuilder bld, int code) {
        bld.addNoad(KtMathPrim.getMathConfig().noadForCode(code));
    }

    public static void handleMathCode(int code, KtToken src) {
        KtBuilder bld = KtMathPrim.getBld();
        KtCharHandler hnd = KtMathPrim.getCharHandler(bld.getClass());
        if (hnd == KtCharHandler.NULL) {
            KtMathPrim.error("CantUseIn", KtMathPrim.str("character"), bld);
        } else if (hnd instanceof KtMathCharHandler) {
            ((KtMathCharHandler)hnd).handleMath(bld, code, src);
        } else {
            KtMathPrim.insertDollar(src);
        }
    }

    public static KtNoad makeOrdNoad(KtField field) {
        KtNoad noad = field.ordinaryNoad();
        return noad != KtNoad.NULL ? noad : new KtOrdNoad(field);
    }

    public static void insertDollar(KtToken src) {
        KtMathPrim.backToken(src);
        KtMathPrim.insertToken(KtMathShiftToken.TOKEN);
        KtMathPrim.error("MissingDollar");
    }

    public static void scanField(KtTreatField proc) {
        boolean again;
        KtField field = KtField.NULL;
        do {
            again = false;
            KtToken tok = KtMathPrim.nextNonRelax();
            KtCommand cmd = KtMathPrim.meaningOf(tok);
            if (cmd.hasMathCodeValue()) {
                field = KtMathPrim.getMathConfig().fieldForCode(cmd.getMathCodeValue());
                continue;
            }
            if (cmd.hasDelCodeValue()) {
                field = KtMathPrim.getMathConfig().fieldForDelCode(cmd.getDelCodeValue());
                continue;
            }
            KtCharCode code = cmd.charCodeToAdd();
            if (code == KtCharCode.NULL) {
                KtMathPrim.backToken(tok);
                continue;
            }
            field = KtMathPrim.getMathConfig().fieldForCode(code.mathCode());
            if (field != KtField.NULL) continue;
            KtMathPrim.backActiveChar(code);
            again = true;
        } while (again);
        if (field != KtField.NULL) {
            proc.execute(field);
        } else {
            KtMathPrim.scanLeftBrace();
            KtMathPrim.pushLevel(new KtMathGroup(proc));
        }
    }

    private static void backActiveChar(KtCharCode code) {
        KtMathPrim.backToken(new KtActiveCharToken(code));
    }

    public static KtDelimiter scanDelimiter() {
        KtCharCode code;
        KtDelimiter del = KtDelimiter.NULL;
        KtToken tok = KtMathPrim.nextNonRelax();
        KtCommand cmd = KtMathPrim.meaningOf(tok);
        if (cmd.hasDelCodeValue()) {
            del = KtMathPrim.getMathConfig().delimiterForDelCode(cmd.getDelCodeValue());
        }
        if ((code = cmd.charCodeToAdd()) != KtCharCode.NULL && cmd.charCode() != KtCharCode.NULL) {
            del = KtMathPrim.getMathConfig().delimiterForDelCode(code.delCode());
        }
        if (del != KtDelimiter.NULL) {
            return del;
        }
        KtMathPrim.backToken(tok);
        KtMathPrim.error("MissingDelim");
        return KtDelimiter.VOID;
    }

    static {
        INTP_MAX_MATH_CODE = KtMathPrim.newIntParam();
        INTP_MAX_DEL_CODE = KtMathPrim.newIntParam();
        DOLLAR = new KtAction(){

            @Override
            public void exec(KtBuilder bld, KtToken src) {
                KtMathPrim.insertDollar(src);
            }
        };
        ZERO_KERN = new KtAction(){

            @Override
            public void exec(KtBuilder bld, KtToken src) {
                bld.addNode(new KtChrKernNode(KtDimen.ZERO));
            }
        };
        LEFT_BRACE = new KtMathAction(){

            @Override
            public void exec(final KtMathBuilder bld, KtToken src) {
                bld.addNoad(new KtOrdNoad(KtEmptyField.FIELD));
                3.pushLevel(new KtMathGroup(new KtTreatField(){

                    @Override
                    public void execute(KtField field) {
                        bld.replaceLastNoad(KtMathPrim.makeOrdNoad(field));
                    }
                }));
            }
        };
    }

    public static interface KtConfig {
        public void initFormula();

        public void initDisplay(KtDimen var1, KtDimen var2, KtDimen var3);

        public KtNoad noadForCode(int var1);

        public KtCharField fieldForCode(int var1);

        public KtNoad noadForDelCode(int var1);

        public KtCharField fieldForDelCode(int var1);

        public KtDelimiter delimiterForDelCode(int var1);

        public KtFontMetric familyFont(byte var1, byte var2);

        public String familyName(byte var1, byte var2);

        public KtMathSpacer mathSpacing(byte var1, byte var2);

        public KtNum mathPenalty(byte var1, byte var2);
    }

    public static class KtMathCharHandler
    implements KtCharHandler {
        @Override
        public void handle(KtBuilder bld, KtCharCode code, KtToken src) {
            KtMathPrim.setMathChar((KtMathBuilder)bld, code);
        }

        @Override
        public void handleSpace(KtBuilder bld, KtToken src) {
        }

        public void handleMath(KtBuilder bld, int code, KtToken src) {
            KtMathPrim.setMathChar((KtMathBuilder)bld, code);
        }
    }

    public static interface KtMathSpacer {
        public KtGlue getGlue(byte var1);

        public String getName();
    }
}

