/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.math;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.math.KtDisplayGroup;
import com.whitemagicsoftware.keentype.math.KtFormulaGroup;
import com.whitemagicsoftware.keentype.math.KtMathPrim;
import com.whitemagicsoftware.keentype.node.KtLinesShape;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.typo.KtAction;
import com.whitemagicsoftware.keentype.typo.KtBuilderCommand;
import com.whitemagicsoftware.keentype.typo.KtParagraph;

public class KtOpenMath
extends KtBuilderCommand {
    private final KtTokenList.KtInserter everyMath;
    private final KtTokenList.KtInserter everyDisplay;
    public final KtAction OPEN_MATH = new KtAction(){

        @Override
        public void exec(KtBuilder bld, KtToken src) {
            KtToken tok = 1.nextRawToken();
            if (1.meaningOf(tok).isMathShift()) {
                KtOpenMath.this.startDisplay();
            } else {
                1.backToken(tok);
                KtOpenMath.this.startFormula();
            }
        }
    };
    public final KtAction OPEN_FORMULA = new KtAction(){

        @Override
        public void exec(KtBuilder bld, KtToken src) {
            2.backToken(2.nextRawToken());
            KtOpenMath.this.startFormula();
        }
    };
    public static final int INTP_DISPLAY_WIDOW_PENALTY = KtOpenMath.newIntParam();
    private static final KtDimen NO_WIDTH = KtDimen.MAX_VALUE.negative();

    public KtOpenMath(KtTokenList.KtInserter everyMath, KtTokenList.KtInserter everyDisplay) {
        this.everyMath = everyMath;
        this.everyDisplay = everyDisplay;
    }

    protected void startDisplay() {
        KtDimen preSize;
        KtDimen.KtPar lastVisibleWidth = new KtDimen.KtPar(NO_WIDTH);
        KtBuilder parBld = KtOpenMath.getBld();
        KtNodeList list = parBld.getParagraph();
        if (list != KtNodeList.NULL) {
            KtParagraph.lineBreak(list, parBld.getStartLine(), KtOpenMath.getConfig().getIntParam(INTP_DISPLAY_WIDOW_PENALTY), parBld.getInitLang(), lastVisibleWidth);
        }
        if ((preSize = lastVisibleWidth.get()) == KtDimen.NULL) {
            preSize = KtDimen.MAX_VALUE;
        } else if (preSize != NO_WIDTH) {
            preSize = preSize.plus(KtOpenMath.getCurrFontMetric().getDimenParam(5).times(2));
        }
        KtLinesShape shape = KtOpenMath.getTypoConfig().linesShape();
        KtBuilder old = KtOpenMath.getBld();
        int lineNo = old.getPrevGraf() + 1;
        KtOpenMath.pushLevel(new KtDisplayGroup());
        KtMathPrim.getMathConfig().initDisplay(preSize, shape.getWidth(lineNo), shape.getIndent(lineNo));
        this.everyDisplay.insertToks();
        old.buildPage();
    }

    protected void startFormula() {
        KtOpenMath.pushLevel(new KtFormulaGroup());
        KtMathPrim.getMathConfig().initFormula();
        this.everyMath.insertToks();
    }

    @Override
    public void addOn(KtLog log) {
        log.add("internal open math");
    }
}

