/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.noad.KtConverter;
import com.whitemagicsoftware.keentype.noad.KtEgg;
import com.whitemagicsoftware.keentype.noad.KtNoadList;
import com.whitemagicsoftware.keentype.noad.KtPureNoad;
import com.whitemagicsoftware.keentype.noad.KtVoidEgg;

public class KtChoiceNoad
extends KtPureNoad {
    private final KtNoadList[] choices;
    private static final char[] stylePrefixes = new char[4];

    public KtChoiceNoad(KtNoadList[] choices) {
        this.choices = choices;
        if (choices.length != 4) {
            throw new RuntimeException("Bad size of math choices");
        }
    }

    @Override
    public final boolean influencesBin() {
        return false;
    }

    @Override
    public KtEgg convert(KtConverter conv) {
        conv.push(this.choices[conv.getStyle()].noads());
        return KtVoidEgg.EGG;
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        log.addEsc(this.getDesc());
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            cntx.addOn(log, this.choices[i].noads(), KtChoiceNoad.getStylePrefix(i));
        }
    }

    protected String getDesc() {
        return "mathchoice";
    }

    public static char getStylePrefix(byte style) {
        return stylePrefixes[style];
    }

    static {
        KtChoiceNoad.stylePrefixes[0] = 68;
        KtChoiceNoad.stylePrefixes[1] = 84;
        KtChoiceNoad.stylePrefixes[2] = 83;
        KtChoiceNoad.stylePrefixes[3] = 115;
    }
}

