/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;

public class KtDelimiter
implements KtLoggable {
    public static final KtDelimiter NULL = null;
    public static final KtDelimiter VOID = new KtDelimiter(0, KtCharCode.NULL, 0, KtCharCode.NULL);
    private final byte smallFam;
    private final KtCharCode smallCode;
    private final byte largeFam;
    private final KtCharCode largeCode;

    public KtDelimiter(byte smallFam, KtCharCode smallCode, byte largeFam, KtCharCode largeCode) {
        this.smallFam = smallFam;
        this.smallCode = smallCode;
        this.largeFam = largeFam;
        this.largeCode = largeCode;
    }

    public byte getSmallFam() {
        return this.smallFam;
    }

    public KtCharCode getSmallCode() {
        return this.smallCode;
    }

    public byte getLargeFam() {
        return this.largeFam;
    }

    public KtCharCode getLargeCode() {
        return this.largeCode;
    }

    public boolean isVoid() {
        return this.smallFam == 0 && this.smallCode == KtCharCode.NULL && this.largeFam == 0 && this.largeCode == KtCharCode.NULL;
    }

    @Override
    public void addOn(KtLog log) {
        int n = (this.famCharNum(this.smallFam, this.smallCode) << 12) + this.famCharNum(this.largeFam, this.largeCode);
        log.add('\"').add(Integer.toHexString(n).toUpperCase());
    }

    private int famCharNum(byte fam, KtCharCode code) {
        int n = fam << 8;
        if (code != KtCharCode.NULL) {
            n += code.numValue();
        }
        return n;
    }
}

