/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.node.KtBreakingCntx;
import com.whitemagicsoftware.keentype.node.KtLinesShape;
import com.whitemagicsoftware.keentype.node.KtNetDimen;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class KtBreaker {
    protected static final KtBreak NULL_BREAK = null;
    protected static final KtFitness NULL_FITNESS = null;
    protected static final int INF_BAD = 10000;
    protected static final int AWFUL_BAD = 0x3FFFFFFF;
    protected int minDem = 0x3FFFFFFF;
    protected final KtFitness TIGHT = new KtFitness(3, NULL_FITNESS);
    protected final KtFitness DECENT = new KtFitness(2, this.TIGHT);
    protected final KtFitness LOOSE = new KtFitness(1, this.DECENT);
    protected final KtFitness VERY_LOOSE;
    protected final KtFitness FITNESS_HEAD = this.VERY_LOOSE = new KtFitness(0, this.LOOSE);
    private KtNodeEnum nodeEnum;
    private int nodeCount = 0;
    protected KtNode[] nodeList = new KtNode[32];
    protected KtLinesShape shape;
    protected int firstLineNo;
    protected int looseness;
    protected int linePen;
    protected int hyphPen;
    protected int exHyphPen;
    protected int adjDem;
    protected int dblHyphDem;
    protected int finHyphDem;
    protected KtNetDimen background;
    protected int threshold;
    protected boolean finPass;
    protected List<KtBreak> breakList;
    private int maxSerial;
    protected KtBreak[] lineBreaks;
    protected int currLineIndex = 0;
    protected KtNodeEnum lastPostBreak = KtNodeEnum.NULL;

    protected KtFitness getFitness(int badness, boolean stretching) {
        if (stretching) {
            if (badness > 99) {
                return this.VERY_LOOSE;
            }
            if (badness > 12) {
                return this.LOOSE;
            }
        } else if (badness > 12) {
            return this.TIGHT;
        }
        return this.DECENT;
    }

    protected void resetDemerits() {
        this.minDem = 0x3FFFFFFF;
        KtFitness fit = this.FITNESS_HEAD;
        while (fit != NULL_FITNESS) {
            fit.reset();
            fit = fit.next;
        }
    }

    public void refeed(KtNodeEnum nodeEnum) {
        this.nodeEnum = nodeEnum;
        this.nodeCount = 0;
    }

    protected final KtNode nodeAt(int i) {
        return this.nodeList[i];
    }

    protected final boolean stillNodeAt(int i) {
        while (this.nodeCount <= i) {
            if (!this.nodeEnum.hasMoreNodes()) {
                return false;
            }
            if (this.nodeList.length <= this.nodeCount) {
                int newLength;
                for (newLength = this.nodeList.length * 2; newLength <= this.nodeCount; newLength *= 2) {
                }
                KtNode[] oldList = this.nodeList;
                this.nodeList = new KtNode[newLength];
                System.arraycopy(oldList, 0, this.nodeList, 0, this.nodeCount);
            }
            this.nodeList[this.nodeCount++] = this.nodeEnum.nextNode();
        }
        return true;
    }

    public KtBreaker(KtNodeEnum nodeEnum, KtLinesShape shape, int firstLineNo, int looseness, int linePen, int hyphPen, int exHyphPen, int adjDem, int dblHyphDem, int finHyphDem) {
        this.nodeEnum = nodeEnum;
        this.shape = shape;
        this.firstLineNo = firstLineNo;
        this.looseness = looseness;
        this.linePen = linePen;
        this.hyphPen = hyphPen;
        this.exHyphPen = exHyphPen;
        this.adjDem = adjDem;
        this.dblHyphDem = dblHyphDem;
        this.finHyphDem = finHyphDem;
    }

    protected void reset() {
        this.breakList = new LinkedList<KtBreak>();
        this.maxSerial = 0;
        this.lineBreaks = null;
        this.currLineIndex = 0;
        this.lastPostBreak = KtNodeEnum.NULL;
        this.resetDemerits();
    }

    public void breakToLines(KtNetDimen background, int threshold, boolean finPass) {
        this.background = background;
        this.threshold = Math.min(threshold, 10000);
        this.finPass = finPass;
        this.reset();
        this.breakList.add(this.DECENT.makeFirst(this.firstLineNo));
        if (this.passNodes()) {
            this.tryBreak(this.nodeCount, -10000, true, KtDimen.ZERO, true);
        }
        KtBreak best = this.bestBreak();
        if (this.looseness != 0 && best != NULL_BREAK) {
            best = this.bestBreak(best.lineNo);
        }
        int n = 0;
        KtBreak brk = best;
        while (brk != NULL_BREAK) {
            ++n;
            brk = brk.prev;
        }
        if (n > 0) {
            this.lineBreaks = new KtBreak[n];
            this.currLineIndex = 1;
            brk = best;
            while (brk != NULL_BREAK) {
                this.lineBreaks[--n] = brk;
                brk = brk.prev;
            }
        }
    }

    public boolean successfullyBroken() {
        return this.currLineIndex > 0;
    }

    public boolean hasMoreLines() {
        return this.currLineIndex > 0 && this.currLineIndex < this.lineBreaks.length;
    }

    public boolean nextLineWasHyphenated() {
        KtBreak brk = this.lineBreaks[this.currLineIndex];
        return brk.hyphenated && brk.count > 0;
    }

    public KtNodeList getNextLine() {
        int i = this.currLineIndex++;
        return this.makeList(this.lineBreaks[i - 1], this.lineBreaks[i]);
    }

    protected KtNodeList makeList(KtBreak before, KtBreak after) {
        int beg = before.index + before.count;
        int end = after.index;
        KtNodeList list = this.lastPostBreak != KtNodeEnum.NULL ? new KtNodeList(this.lastPostBreak) : new KtNodeList(end - beg);
        list.append(this.nodeList, beg, end - beg);
        if (after.count > 0) {
            KtNode node = this.nodeList[end];
            list.append(node.atBreakReplacement());
            this.lastPostBreak = node.postBreakNodes();
        } else {
            this.lastPostBreak = KtNodeEnum.NULL;
        }
        return list;
    }

    protected KtBreak bestBreak() {
        int fewestDem = 0x3FFFFFFF;
        KtBreak best = NULL_BREAK;
        for (KtBreak brk : this.breakList) {
            if (brk.demerits >= fewestDem) continue;
            best = brk;
            fewestDem = brk.demerits;
        }
        return best;
    }

    protected KtBreak bestBreak(int bestLineNo) {
        int desiredLineNo = bestLineNo + this.looseness;
        int fewestDem = 0x3FFFFFFF;
        KtBreak best = NULL_BREAK;
        for (KtBreak brk : this.breakList) {
            if (bestLineNo < brk.lineNo && brk.lineNo <= desiredLineNo || bestLineNo > brk.lineNo && brk.lineNo >= desiredLineNo) {
                best = brk;
                fewestDem = brk.demerits;
                bestLineNo = brk.lineNo;
                continue;
            }
            if (brk.lineNo != bestLineNo || brk.demerits >= fewestDem) continue;
            best = brk;
            fewestDem = brk.demerits;
        }
        return bestLineNo == desiredLineNo || this.finPass ? best : NULL_BREAK;
    }

    protected boolean passNodes() {
        KtBreakingContext brkContext = new KtBreakingContext();
        int i = 0;
        while (this.stillNodeAt(i)) {
            KtNode node = this.nodeAt(i);
            if (node.allowsSpaceBreaking()) {
                brkContext.space = true;
            } else if (node.forbidsSpaceBreaking()) {
                brkContext.space = false;
            }
            if (!node.isKernBreak() || this.stillNodeAt(i + 1) && this.nodeAt(i + 1).canFollowKernBreak()) {
                brkContext.atSkip = i > 0 && this.nodeAt(i - 1).canPrecedeSkipBreak();
                int pen = node.breakPenalty(brkContext);
                if (pen < 10000) {
                    KtDimen preWidth = node.preBreakWidth();
                    this.actWidth().add(preWidth);
                    this.tryBreak(i, Math.max(pen, -10000), node.isHyphenBreak(), preWidth, false);
                    if (this.breakList.isEmpty()) {
                        return false;
                    }
                    this.actWidth().sub(preWidth);
                }
            }
            this.checkShrinkage(node);
            KtBreaker.add(this.actWidth(), node);
            ++i;
        }
        return true;
    }

    private KtNetDimen actWidth() {
        return this.breakList.get((int)0).delta;
    }

    protected void tryBreak(int idx, int pen, boolean hyphen, KtDimen preWidth, boolean last) {
        KtNetDimen currWidth = new KtNetDimen(this.background);
        ListIterator<KtBreak> iterator = this.breakList.listIterator();
        int oldLineNo = 0;
        while (iterator.hasNext()) {
            int dem;
            KtFitness fitness;
            int badness;
            KtBreak brk = iterator.next();
            if (brk.lineNo > oldLineNo) {
                if (this.looseness != 0 || !this.shape.isFinal(brk.lineNo)) {
                    oldLineNo = brk.lineNo;
                    if (this.minDem < 0x3FFFFFFF) {
                        iterator.previous();
                        this.createActive(idx, iterator, currWidth, hyphen, preWidth);
                        iterator.next();
                    }
                } else {
                    oldLineNo = Integer.MAX_VALUE;
                }
            }
            currWidth.add(brk.delta);
            KtDimen diff = this.shape.getWidth(brk.lineNo).minus(currWidth.getNatural());
            if (diff.moreThan(0)) {
                badness = currWidth.getMaxStrOrder() > 0 ? 0 : diff.badness(currWidth.getStretch((byte)0));
                fitness = this.getFitness(badness, true);
            } else {
                badness = (diff = diff.negative()).moreThan(currWidth.getShrink()) ? 10001 : diff.badness(currWidth.getShrink());
                fitness = this.getFitness(badness, false);
            }
            if (badness > 10000 || pen == -10000) {
                if (this.finPass && this.minDem == 0x3FFFFFFF && this.breakList.size() == 1) {
                    this.traceBreak(idx, brk.serial, badness, pen, 0, true);
                    this.recordFeasible(brk, fitness, 0);
                } else if (badness <= this.threshold) {
                    dem = this.demerits(pen, badness) + this.demerits(brk, fitness, hyphen, last);
                    this.traceBreak(idx, brk.serial, badness, pen, dem, false);
                    this.recordFeasible(brk, fitness, dem);
                }
                iterator.remove();
                if (iterator.hasNext()) {
                    iterator.next().delta.add(brk.delta);
                    iterator.previous();
                }
                currWidth.sub(brk.delta);
                brk.delta = KtNetDimen.NULL;
                continue;
            }
            if (badness > this.threshold) continue;
            dem = this.demerits(pen, badness) + this.demerits(brk, fitness, hyphen, last);
            this.traceBreak(idx, brk.serial, badness, pen, dem, false);
            this.recordFeasible(brk, fitness, dem);
        }
        if (this.minDem < 0x3FFFFFFF) {
            this.createActive(idx, iterator, currWidth, hyphen, preWidth);
        }
    }

    protected void createActive(int idx, ListIterator<KtBreak> iterator, KtNetDimen width, boolean hyphen, KtDimen preWidth) {
        int absAdjDem = Math.abs(this.adjDem);
        int limit = 0x3FFFFFFF - this.minDem <= absAdjDem ? 0x3FFFFFFE : this.minDem + absAdjDem;
        int cnt = this.breakCount(idx);
        KtNetDimen delta = this.breakWidth(idx, cnt);
        delta.add(preWidth);
        delta.sub(width);
        KtFitness fit = this.FITNESS_HEAD;
        while (fit != NULL_FITNESS) {
            if (fit.fits(limit)) {
                if (delta != KtNetDimen.NULL) {
                    best = fit.makeBest(idx, cnt, hyphen, delta);
                    iterator.add(best);
                    this.traceBreak(best);
                    if (iterator.hasNext()) {
                        iterator.next().delta.sub(best.delta);
                        iterator.previous();
                    }
                    width.add(delta);
                    delta = KtNetDimen.NULL;
                } else {
                    best = fit.makeBest(idx, cnt, hyphen, new KtNetDimen());
                    iterator.add(best);
                    this.traceBreak(best);
                }
            }
            fit.reset();
            fit = fit.next;
        }
        this.minDem = 0x3FFFFFFF;
    }

    protected int demerits(int pen, int badness) {
        int dem = Math.abs(this.linePen + badness);
        if (dem > 10000) {
            dem = 10000;
        }
        dem *= dem;
        if (pen != 0) {
            if (pen > 0) {
                dem += pen * pen;
            } else if (pen > -10000) {
                dem -= pen * pen;
            }
        }
        return dem;
    }

    protected int demerits(KtBreak brk, KtFitness fitness, boolean hyphen, boolean last) {
        int dem = 0;
        if (brk.hyphenated) {
            if (last) {
                dem += this.finHyphDem;
            } else if (hyphen) {
                dem += this.dblHyphDem;
            }
        }
        if (!fitness.adjoins(brk.fitness)) {
            dem += this.adjDem;
        }
        return dem;
    }

    protected void recordFeasible(KtBreak brk, KtFitness fitness, int dem) {
        fitness.update(dem += brk.demerits, brk);
        if (this.minDem > dem) {
            this.minDem = dem;
        }
    }

    protected int breakCount(int idx) {
        int j = idx;
        if (this.stillNodeAt(j) && this.nodeAt(j++).discardsAfter()) {
            while (this.stillNodeAt(j) && this.nodeAt(j).discardable()) {
                ++j;
            }
        }
        return j - idx;
    }

    protected KtNetDimen breakWidth(int idx, int cnt) {
        KtNetDimen netDim = new KtNetDimen(this.background);
        if (cnt > 0) {
            netDim.add(this.nodeAt(idx).postBreakWidth());
        }
        for (int j = 0; j < cnt; ++j) {
            KtBreaker.sub(netDim, this.nodeAt(idx + j));
        }
        return netDim;
    }

    protected static void add(KtNetDimen netDim, KtNode node) {
        netDim.add(node.getLeftX());
        netDim.add(node.getWidth());
        netDim.addShrink(node.getWshr());
        netDim.addStretch(node.getWstrOrd(), node.getWstr());
    }

    protected static void sub(KtNetDimen netDim, KtNode node) {
        netDim.sub(node.getLeftX());
        netDim.sub(node.getWidth());
        netDim.subShrink(node.getWshr());
        netDim.subStretch(node.getWstrOrd(), node.getWstr());
    }

    protected void checkShrinkage(KtNode node) {
    }

    protected abstract void traceBreak(int var1, int var2, int var3, int var4, int var5, boolean var6);

    protected abstract void traceBreak(KtBreak var1);

    protected class KtFitness
    implements KtLoggable {
        private final int code;
        public final KtFitness next;
        private int minDem = 0x3FFFFFFF;
        private KtBreak best = NULL_BREAK;

        public KtFitness(int code, KtFitness next) {
            this.code = code;
            this.next = next;
        }

        @Override
        public void addOn(KtLog log) {
            log.add(this.code);
        }

        public boolean adjoins(KtFitness other) {
            return this.equals(other) || other.equals(this.next) || this.equals(other.next);
        }

        public void update(int dem, KtBreak brk) {
            if (this.minDem >= dem) {
                this.minDem = dem;
                this.best = brk;
            }
        }

        public void reset() {
            this.minDem = 0x3FFFFFFF;
            this.best = NULL_BREAK;
        }

        public boolean fits(int limit) {
            return this.minDem <= limit;
        }

        public KtBreak makeFirst(int lineNo) {
            return new KtBreak(0, 0, lineNo, this, false, 0, KtBreaker.this.maxSerial++, NULL_BREAK, new KtNetDimen());
        }

        public KtBreak makeBest(int idx, int cnt, boolean hyphenated, KtNetDimen delta) {
            if (this.best == NULL_BREAK) {
                throw new RuntimeException("no best break");
            }
            return new KtBreak(idx, cnt, this.best.lineNo + 1, this, hyphenated, this.minDem, KtBreaker.this.maxSerial++, this.best, delta);
        }

        public String toString() {
            return Integer.toString(this.code);
        }
    }

    protected static class KtBreak {
        public final int index;
        public final int count;
        public final int lineNo;
        public final KtFitness fitness;
        public final boolean hyphenated;
        public final int demerits;
        public final int serial;
        public final KtBreak prev;
        public KtNetDimen delta;

        public KtBreak(int index, int count, int lineNo, KtFitness fitness, boolean hyphenated, int demerits, int serial, KtBreak prev, KtNetDimen delta) {
            this.index = index;
            this.count = count;
            this.lineNo = lineNo;
            this.fitness = fitness;
            this.hyphenated = hyphenated;
            this.demerits = demerits;
            this.serial = serial;
            this.prev = prev;
            this.delta = delta;
        }
    }

    protected class KtBreakingContext
    implements KtBreakingCntx {
        public boolean space = true;
        public boolean atSkip = true;

        protected KtBreakingContext() {
        }

        @Override
        public boolean spaceBreaking() {
            return this.space;
        }

        @Override
        public boolean allowedAtSkip() {
            return this.atSkip;
        }

        @Override
        public int hyphenPenalty() {
            return KtBreaker.this.hyphPen;
        }

        @Override
        public int exHyphenPenalty() {
            return KtBreaker.this.exHyphPen;
        }
    }
}

