/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.node.KtAnyShiftNode;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtSettingContext;
import com.whitemagicsoftware.keentype.node.KtTypesetter;

public class KtHShiftNode
extends KtAnyShiftNode {
    protected KtHShiftNode(KtNode node, KtDimen shift) {
        super(node, shift);
    }

    public static KtNode shiftingUp(KtNode node, KtDimen shift) {
        return shift.isZero() ? node : new KtHShiftNode(node, shift.negative());
    }

    public static KtNode shiftingDown(KtNode node, KtDimen shift) {
        return shift.isZero() ? node : new KtHShiftNode(node, shift);
    }

    @Override
    public KtDimen getHeight() {
        return this.node.getHeight().minus(this.shift);
    }

    @Override
    public KtDimen getWidth() {
        return this.node.getWidth();
    }

    @Override
    public KtDimen getDepth() {
        return this.node.getDepth().plus(this.shift);
    }

    @Override
    public KtDimen getLeftX() {
        return this.node.getLeftX();
    }

    @Override
    public void typeSet(KtTypesetter setter, KtSettingContext sctx) {
        setter.moveDown(this.shift);
        this.node.typeSet(setter, sctx.shiftedUp(this.shift));
        setter.moveUp(this.shift);
    }

    @Override
    public KtDimen getHeight(KtGlueSetting setting) {
        return this.node.getHeight(setting).minus(this.shift);
    }

    @Override
    public KtDimen getWidth(KtGlueSetting setting) {
        return this.node.getWidth(setting);
    }

    @Override
    public KtDimen getDepth(KtGlueSetting setting) {
        return this.node.getDepth(setting).plus(this.shift);
    }

    @Override
    public KtDimen getLeftX(KtGlueSetting setting) {
        return this.node.getLeftX(setting);
    }

    public String toString() {
        return "HShift(" + String.valueOf(this.node) + "; " + String.valueOf(this.shift) + ")";
    }
}

