/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.svg;

import com.whitemagicsoftware.keentype.render.KtCanvas;
import com.whitemagicsoftware.keentype.render.KtFastDouble;
import com.whitemagicsoftware.keentype.render.KtFontReader;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;

public final class KtSvgFormatWriter
implements KtCanvas<String> {
    private static final int PRECISION = 4;
    private static final int BUFFER_SIZE = 65536;
    private static final String HEADER = "<svg xmlns='http://www.w3.org/2000/svg' version='1.1' ";
    private static final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private Font mFont = KtFontReader.DEFAULT_FONT;
    private final StringBuilder mSvg = new StringBuilder(65536);
    private final StringBuilder mDoc = new StringBuilder(65536);
    private final float[] mCoords = new float[6];
    private boolean mClosed;
    private double mW;
    private double mH;

    @Override
    public void setFont(Font font) {
        assert (font != null);
        this.mFont = font;
    }

    @Override
    public void drawString(String s, double x, double y) {
        assert (s != null);
        GlyphVector glyphs = this.mFont.createGlyphVector(RENDER_CONTEXT, s);
        Path2D path = (Path2D)glyphs.getOutline((float)x, (float)y);
        this.mSvg.append("<g><path ");
        if (path.getWindingRule() == 0) {
            this.mSvg.append("fill-rule='evenodd' ");
        }
        this.mSvg.append("d='");
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(this.mCoords)) {
                case 0: {
                    this.mSvg.append('M').append(this.toGeometryPrecision(this.mCoords[0])).append(' ').append(this.toGeometryPrecision(this.mCoords[1]));
                    break;
                }
                case 1: {
                    this.mSvg.append('L').append(this.toGeometryPrecision(this.mCoords[0])).append(' ').append(this.toGeometryPrecision(this.mCoords[1]));
                    break;
                }
                case 2: {
                    this.mSvg.append('Q').append(this.toGeometryPrecision(this.mCoords[0])).append(' ').append(this.toGeometryPrecision(this.mCoords[1])).append(' ').append(this.toGeometryPrecision(this.mCoords[2])).append(' ').append(this.toGeometryPrecision(this.mCoords[3]));
                    break;
                }
                case 3: {
                    this.mSvg.append('C').append(this.toGeometryPrecision(this.mCoords[0])).append(' ').append(this.toGeometryPrecision(this.mCoords[1])).append(' ').append(this.toGeometryPrecision(this.mCoords[2])).append(' ').append(this.toGeometryPrecision(this.mCoords[3])).append(' ').append(this.toGeometryPrecision(this.mCoords[4])).append(' ').append(this.toGeometryPrecision(this.mCoords[5]));
                    break;
                }
                case 4: {
                    this.mSvg.append('Z');
                }
            }
            iterator.next();
        }
        this.mSvg.append("'/></g>");
        Rectangle bounds = path.getBounds();
        this.updateExtents(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2, double strokeWidth) {
        this.mSvg.append("<g><line ").append("stroke='#000000' ").append("stroke-linecap='round' ").append("stroke-width='").append(strokeWidth).append("' x1='").append(this.toGeometryPrecision(x1)).append("' y1='").append(this.toGeometryPrecision(y1)).append("' x2='").append(this.toGeometryPrecision(x2)).append("' y2='").append(this.toGeometryPrecision(y2)).append("'/></g>");
        this.updateExtents(x2, y2);
    }

    @Override
    public String export(double scale) {
        return this.export(this.mW + 1.0, this.mH + 1.0, scale);
    }

    @Override
    public String export(double w, double h, double scale) {
        if (this.mClosed) {
            return this.mDoc.toString();
        }
        this.mClosed = true;
        String tScale = KtFastDouble.toString(scale, 4);
        return this.mDoc.append(HEADER).append("width='").append(KtFastDouble.toString(w * scale, 4)).append("' height='").append(KtFastDouble.toString(h * scale, 4)).append("'><g transform='scale(").append(tScale).append(',').append(tScale).append(")'>").append((CharSequence)this.mSvg).append("</g></svg>").toString();
    }

    public void reset() {
        this.mSvg.setLength(0);
        this.mDoc.setLength(0);
        this.mW = 0.0;
        this.mH = 0.0;
        this.mClosed = false;
    }

    private void updateExtents(double w, double h) {
        if (w > this.mW) {
            this.mW = w;
        }
        if (h > this.mH) {
            this.mH = h;
        }
    }
}

