/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.svg;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.render.KtCoordinateStack;
import com.whitemagicsoftware.keentype.render.KtPendingRule;
import com.whitemagicsoftware.keentype.render.KtTurtle;
import com.whitemagicsoftware.keentype.svg.KtSvgFormatWriter;
import com.whitemagicsoftware.keentype.tex.KtFileFormat;
import com.whitemagicsoftware.keentype.tex.KtFontInfo;
import com.whitemagicsoftware.keentype.tex.KtFontInformator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class KtSvgTypesetter
implements KtTypesetter {
    private KtFileName mFileName;
    private OutputStream mOutput;
    private KtTurtle mTurtle;
    private KtCoordinateStack mStack;
    private KtFontMetric mCurrentFontMetric = KtFontMetric.NULL;
    private KtFontInfo mCurrentFontInfo = KtFontInfo.NULL;
    private KtPendingRule mPendingRule = KtPendingRule.NULL;
    private KtDimen mPageWidth;
    private KtDimen mPageHeight;
    private double mScale = 1.0;
    private final KtFontInformator mFontInf;
    private final Map<KtFontMetric, KtFontInfo> mFontMetrics = new HashMap<KtFontMetric, KtFontInfo>(64);
    private final boolean mFullPage;
    private final KtSvgFormatWriter mWriter = new KtSvgFormatWriter();

    public KtSvgTypesetter(KtFontInformator fontInf) {
        this(fontInf, false);
    }

    public KtSvgTypesetter(KtFontInformator fontInf, boolean fullPage) {
        assert (fontInf != null);
        this.mFontInf = fontInf;
        this.mFullPage = fullPage;
    }

    @Override
    public void set(char ch, KtFontMetric metric) {
        KtDimen w;
        this.mTurtle.sync();
        if (!metric.equals(this.mCurrentFontMetric)) {
            KtFontInfo info = this.mFontMetrics.computeIfAbsent(metric, k -> this.mFontInf.getInfo(metric));
            this.mTurtle.font(info);
            this.mCurrentFontMetric = metric;
            this.mCurrentFontInfo = info;
        }
        if ((w = this.mCurrentFontInfo.getCharWidth(ch)) != KtDimen.NULL) {
            this.mTurtle.draw(ch);
            this.mTurtle.advance(w);
        }
    }

    @Override
    public void set(KtCharCode code, KtFontMetric metric) {
        this.set(code.toChar(), metric);
    }

    @Override
    public void setRule(KtDimen h, KtDimen w) {
        if (!h.lessThan(0) && !w.lessThan(0)) {
            this.mTurtle.sync();
            this.mPendingRule = new KtPendingRule(this.mTurtle, w, h);
        }
    }

    @Override
    public void setSpecial(byte[] spec) {
        this.mTurtle.sync();
    }

    @Override
    public void moveLeft(KtDimen x) {
        this.mTurtle.left(x);
        this.tryToSetPendRule();
    }

    @Override
    public void moveRight(KtDimen x) {
        this.mTurtle.right(x);
        this.tryToSetPendRule();
    }

    @Override
    public void moveUp(KtDimen y) {
        this.mTurtle.up(y);
    }

    @Override
    public void moveDown(KtDimen y) {
        this.mTurtle.down(y);
    }

    @Override
    public KtTypesetter.KtMark mark() {
        return this.mTurtle.mark();
    }

    @Override
    public void syncHoriz() {
        this.putPendRule();
        this.mTurtle.syncHorizontal();
    }

    @Override
    public void syncVert() {
        this.putPendRule();
        this.mTurtle.syncVertical();
    }

    @Override
    public void push() {
        this.putPendRule();
        this.mStack = this.mTurtle.stack(this.mStack);
    }

    @Override
    public void pop() {
        this.putPendRule();
        if (this.mStack != KtCoordinateStack.NULL) {
            this.mTurtle.moveSvgTo(this.mStack.x(), this.mStack.y());
            this.mStack = this.mStack.next();
        }
    }

    @Override
    public void startPage(KtDimen yOffset, KtDimen xOffset, KtDimen height, KtDimen width, int[] paragraphs) {
        assert (yOffset != null);
        assert (xOffset != null);
        assert (height != null);
        assert (width != null);
        this.mPageWidth = width.plus(xOffset);
        this.mPageHeight = height.plus(yOffset);
        this.mCurrentFontMetric = KtFontMetric.NULL;
        this.mCurrentFontInfo = KtFontInfo.NULL;
        this.mTurtle = new KtTurtle(KtDimen.ZERO, KtDimen.ZERO, xOffset, yOffset, this.mWriter);
        this.mStack = KtCoordinateStack.NULL;
    }

    @Override
    public int pageCount() {
        return 1;
    }

    @Override
    public void endPage() {
    }

    @Override
    public void startDocument(OutputStream os) {
        this.mOutput = os;
        this.mWriter.reset();
    }

    @Override
    public void close() {
        String svg = this.mFullPage ? (String)this.mWriter.export(this.mPageWidth.toDouble(), this.mPageHeight.toDouble()) : this.mWriter.export(this.mScale);
        try {
            this.mOutput.write(svg.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                this.mOutput.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void putPendRule() {
        if (this.mPendingRule != KtPendingRule.NULL) {
            this.mPendingRule.put();
            this.mPendingRule = KtPendingRule.NULL;
        }
    }

    private void tryToSetPendRule() {
        if (this.mPendingRule != KtPendingRule.NULL && this.mPendingRule.canBeSet()) {
            this.mPendingRule.set();
            this.mPendingRule = KtPendingRule.NULL;
        }
    }

    @Override
    public void setScale(double scale) {
        assert (scale > 0.0);
        this.mScale = scale;
    }

    @Override
    public void setFileName(KtFileName fileName) {
        assert (fileName != null);
        this.mFileName = this.addExtension(fileName);
    }

    @Override
    public Optional<KtFileName> getFileName() {
        return Optional.ofNullable(this.mFileName);
    }

    @Override
    public KtFileFormat getExtension() {
        return KtFileFormat.SVG_EXT;
    }
}

