/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.builder.KtOutputBuilder;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtCountPrim;
import com.whitemagicsoftware.keentype.command.KtDimenPrim;
import com.whitemagicsoftware.keentype.command.KtSkipPrim;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtPageSplit;
import com.whitemagicsoftware.keentype.node.KtPenaltyNode;
import com.whitemagicsoftware.keentype.node.KtSizesEvaluator;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.node.KtVoidBoxNode;
import com.whitemagicsoftware.keentype.typo.KtSetBoxPrim;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;
import com.whitemagicsoftware.keentype.typo.KtVSplitPrim;
import com.whitemagicsoftware.keentype.typo.KtVertGroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class KtPage
extends KtTypoCommand {
    public static final int BOOLP_TRACING_PAGES = KtPage.newBoolParam();
    public static final int DIMP_VSIZE = KtPage.newDimParam();
    public static final int DIMP_MAX_DEPTH = KtPage.newDimParam();
    public static final int GLUEP_TOP_SKIP = KtPage.newGlueParam();
    public static final int TOKSP_OUTPUT = KtPage.newToksParam();
    public static final int INTP_MAX_DEAD_CYCLES = KtPage.newIntParam();
    public static final int BOOLP_HOLDING_INSERTS = KtPage.newBoolParam();
    private static List pageList;

    private static boolean tracing() {
        return KtPage.getConfig().getBoolParam(BOOLP_TRACING_PAGES);
    }

    private static String badToString(int b) {
        return b >= 0x3FFFFFFF ? "*" : Integer.toString(b);
    }

    public static KtPageSplit getPageSplit() {
        return pageList;
    }

    public static List getPageList() {
        return pageList;
    }

    public static void makeStaticData(KtCountPrim countReg, KtDimenPrim dimenReg, KtSkipPrim skipReg, KtSetBoxPrim boxReg, KtTokenList.KtMaintainer topMark, KtTokenList.KtMaintainer firstMark, KtTokenList.KtMaintainer botMark) {
        pageList = new List(countReg, dimenReg, skipReg, boxReg, topMark, firstMark, botMark);
    }

    public static void writeStaticData(ObjectOutputStream output) throws IOException {
        output.writeObject(pageList);
    }

    public static void readStaticData(ObjectInputStream input) throws IOException, ClassNotFoundException {
        pageList = (List)input.readObject();
    }

    public static class List
    extends KtPageSplit {
        private final KtCountPrim countReg;
        private final KtDimenPrim dimenReg;
        private final KtSkipPrim skipReg;
        private final KtSetBoxPrim boxReg;
        private final KtTokenList.KtMaintainer topMark;
        private final KtTokenList.KtMaintainer firstMark;
        private final KtTokenList.KtMaintainer botMark;
        protected boolean active = false;
        public int deadCycles = 0;
        private static final KtTypoCommand.KtVBoxPacker pagePacker = new KtTypoCommand.KtVBoxPacker(){

            @Override
            public boolean check(KtSizesEvaluator pack) {
                return false;
            }
        };

        public List(KtCountPrim countReg, KtDimenPrim dimenReg, KtSkipPrim skipReg, KtSetBoxPrim boxReg, KtTokenList.KtMaintainer topMark, KtTokenList.KtMaintainer firstMark, KtTokenList.KtMaintainer botMark) {
            this.countReg = countReg;
            this.dimenReg = dimenReg;
            this.skipReg = skipReg;
            this.boxReg = boxReg;
            this.topMark = topMark;
            this.firstMark = firstMark;
            this.botMark = botMark;
        }

        public boolean outputActive() {
            return this.active;
        }

        public boolean canChangeNums() {
            return true;
        }

        @Override
        public void build() {
            if (!this.active) {
                super.build();
            }
        }

        @Override
        public boolean canChangeDimens() {
            return super.canChangeDimens() && !this.active;
        }

        @Override
        public void show(KtLog log, int depth, int breadth) {
            this.show(log, depth, breadth, this.active);
        }

        public int getDeadCycles() {
            return this.deadCycles;
        }

        public void resetDeadCycles() {
            this.deadCycles = 0;
        }

        @Override
        protected void initSpecs() {
            this.goal = KtCommandBase.getConfig().getDimParam(DIMP_VSIZE);
            this.maxDepth = KtCommandBase.getConfig().getDimParam(DIMP_MAX_DEPTH);
            if (KtPage.tracing()) {
                KtCommandBase.diagLog.startLine().add("%% goal height=").add(this.goal.toString()).add(", max depth=").add(this.maxDepth.toString()).startLine();
            }
        }

        @Override
        protected void setInsVBox(int num, KtBox box) {
            this.boxReg.foist(num, box);
        }

        @Override
        protected KtBox getInsVBox(int num) {
            KtBox box = this.boxReg.get(num);
            if (!box.isVoid() && !box.isVBox()) {
                KtCommandBase.error("MisplacedInsert");
                this.boxReg.showAndPurge(num);
                box = this.boxReg.get(num);
            }
            return box;
        }

        @Override
        protected KtGlue getInsSkip(int num) {
            KtGlue skip = this.skipReg.get(num);
            if (skip.getShrOrder() != 0 && !skip.getShrink().isZero()) {
                KtCommandBase.error("InfShrinkInsert", this.skipReg, KtCommandBase.num(num));
            }
            return skip;
        }

        @Override
        protected KtDimen getInsSize(int num) {
            return this.dimenReg.get(num);
        }

        @Override
        protected int getInsFactor(int num) {
            return this.countReg.get(num).intVal();
        }

        protected void foistOutputBox(KtBox box) {
            this.boxReg.foist(KtCommandBase.getConfig().getIntParam(KtTypoCommand.INTP_OUTPUT_BOX_NUM), box);
        }

        protected void checkOutputBox(String ident) {
            int num = KtCommandBase.getConfig().getIntParam(KtTypoCommand.INTP_OUTPUT_BOX_NUM);
            if (!this.boxReg.get(num).isVoid()) {
                KtCommandBase.error(ident, KtCommandBase.esc(this.boxReg.getDesc()), KtCommandBase.num(num));
                this.boxReg.showAndPurge(num);
            }
        }

        @Override
        protected void traceSplitCost(int num, KtDimen space, KtDimen best, int cost) {
            if (KtPage.tracing()) {
                KtCommandBase.diagLog.startLine().add("% split").add(num).add(" to ").add(space.toString()).add(',').add(best.toString()).add(" p=").add(cost).startLine();
            }
        }

        @Override
        protected boolean insertsWanted() {
            return !KtCommandBase.getConfig().getBoolParam(BOOLP_HOLDING_INSERTS);
        }

        @Override
        protected KtNode splitTopAdjustment(KtDimen height, KtGlue topSkip) {
            return KtVSplitPrim.makeTopAdjustment(height, KtTypoCommand.GLUEP_SPLIT_TOP_SKIP, topSkip);
        }

        @Override
        protected KtNode topAdjustment(KtDimen height) {
            return KtVSplitPrim.makeTopAdjustment(height, GLUEP_TOP_SKIP);
        }

        @Override
        protected void traceCost(int pen, int bad, int cost, boolean best) {
            if (KtPage.tracing()) {
                KtCommandBase.diagLog.startLine().add("% t=").add(this.soFar.toString()).add(" g=").add(this.goal.toString()).add(" b=").add(KtPage.badToString(bad)).add(" p=").add(pen).add(" c=").add(KtPage.badToString(cost));
                if (best) {
                    KtCommandBase.diagLog.add('#');
                }
                KtCommandBase.diagLog.startLine();
            }
        }

        @Override
        protected boolean performOutput(KtNodeList list, KtDimen height) {
            this.setOutputPenalty();
            this.setMarks(list);
            this.checkOutputBox("NonEmptyOutBox");
            KtVBoxNode box = pagePacker.packVBox(list, height, true, this.maxDepth);
            KtTokenList.KtInserter output = KtCommandBase.getConfig().getToksInserter(TOKSP_OUTPUT);
            if (!output.isEmpty()) {
                this.foistOutputBox(box);
                if (this.deadCycles < KtCommandBase.getConfig().getIntParam(INTP_MAX_DEAD_CYCLES)) {
                    this.active = true;
                    ++this.deadCycles;
                    KtCommandBase.pushLevel(new KtOutputGroup());
                    output.insertToks();
                    KtCommandBase.scanLeftBrace();
                    this.depth = KtDimen.ZERO;
                    return true;
                }
                KtCommandBase.error("TooMuchDead", KtCommandBase.num(this.deadCycles));
            }
            this.foistOutputBox(KtVoidBoxNode.BOX);
            KtTypoCommand.shipOut(box);
            this.startNextPage();
            return false;
        }

        private void setOutputPenalty() {
            int pen = -10000;
            if (!this.isEmpty()) {
                pen = 10000;
                KtNode node = this.nodeAt(0);
                if (node.isPenalty()) {
                    this.data.set(0, new KtPenaltyNode(KtNum.valueOf(pen)));
                    pen = node.getPenalty().intVal();
                }
            }
            KtTypoCommand.getTypoConfig().setOutputPenalty(pen);
        }

        private void setMarks(KtNodeList list) {
            this.topMark.setToksValue(this.botMark.getToksValue());
            if (!KtVSplitPrim.setMarks(list.nodes(), this.firstMark, this.botMark)) {
                this.firstMark.setToksValue(this.topMark.getToksValue());
            }
        }

        public class KtOutputGroup
        extends KtVertGroup {
            protected KtOutputGroup() {
                super(new KtOutputBuilder(KtOutputGroup.currLineNumber()));
            }

            @Override
            public void stop() {
                KtOutputGroup.getTokStack().dropFinishedPop();
                super.stop();
            }

            @Override
            public void close() {
                List.this.active = false;
                List.this.insertPenalties = 0;
                List.this.checkOutputBox("NonEmptyOutBoxAfter");
                List.this.startNextPage(this.builder.getList().nodes());
                super.close();
                List.this.build();
            }
        }
    }
}

