/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.builder.KtVertBuilder;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtCntxLoggableEnum;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.node.KtAnyBoxNode;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtHBoxNode;
import com.whitemagicsoftware.keentype.node.KtHorizIterator;
import com.whitemagicsoftware.keentype.node.KtLanguage;
import com.whitemagicsoftware.keentype.node.KtLinesShape;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtRuleNode;
import com.whitemagicsoftware.keentype.node.KtSizesEvaluator;
import com.whitemagicsoftware.keentype.node.KtTreatBox;
import com.whitemagicsoftware.keentype.node.KtTreatNode;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.node.KtVertIterator;
import com.whitemagicsoftware.keentype.node.KtWordBuilder;
import com.whitemagicsoftware.keentype.typo.KtCharHandler;
import com.whitemagicsoftware.keentype.typo.KtFontMetricEquiv;
import com.whitemagicsoftware.keentype.typo.KtNullFontMetric;
import com.whitemagicsoftware.keentype.typo.KtParagraph;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class KtTypoCommand
extends KtCommand {
    private static KtTypoHandler typoHandler;
    private static KtFontMetricEquiv currFontMetric;
    private static KtConfig config;
    public static final int BOOLP_TRACING_LOST_CHARS;
    public static final KtTreatNode APPENDER;
    public static final int GLUEP_SPACE;
    public static final int GLUEP_XSPACE;
    public static final int DIMP_LINE_SKIP_LIMIT;
    public static final int GLUEP_LINE_SKIP;
    public static final int GLUEP_BASELINE_SKIP;
    public static final int INTP_SHOW_BOX_DEPTH;
    public static final int INTP_SHOW_BOX_BREADTH;
    public static final int INTP_HBADNESS;
    public static final int DIMP_HFUZZ;
    public static final int DIMP_OVERFULL_RULE;
    public static final int INTP_VBADNESS;
    public static final int DIMP_VFUZZ;
    private static final KtHBoxPacker hPacker;
    private static final KtVBoxPacker vPacker;
    public static final int DIMP_BOX_MAX_DEPTH;
    public static final int DIMP_SPLIT_MAX_DEPTH;
    public static final int GLUEP_SPLIT_TOP_SKIP;
    public static final int INTP_OUTPUT_BOX_NUM;
    public static final int BOOLP_TRACING_OUTPUT;
    public static final int DIMP_H_OFFSET;
    public static final int DIMP_V_OFFSET;

    public static KtBuilder getBld() {
        return KtBuilder.top();
    }

    public static void illegalCase(KtCommand cmd, KtBuilder bld) {
        KtTypoCommand.error("CantUseIn", cmd, bld);
    }

    public void illegalCase(KtBuilder bld) {
        KtTypoCommand.illegalCase(this, bld);
    }

    public static KtTypoHandler getTypoHandler() {
        return typoHandler;
    }

    public static void setTypoHandler(KtTypoHandler hand) {
        typoHandler = hand;
    }

    public static void setTypesetter(KtTypesetter typeSetter) {
        typoHandler.setTypesetter(typeSetter);
    }

    public static KtFontMetric getCurrFontMetric() {
        return currFontMetric.get();
    }

    public static void setCurrFontMetric(KtFontMetric val, boolean glob) {
        currFontMetric.set(val, glob);
    }

    public static void makeStaticData() {
        currFontMetric = new KtFontMetricEquiv();
    }

    public static void writeStaticData(ObjectOutputStream output) throws IOException {
        output.writeObject(currFontMetric);
    }

    public static void readStaticData(ObjectInputStream input) throws IOException, ClassNotFoundException {
        currFontMetric = (KtFontMetricEquiv)input.readObject();
    }

    public static void setTypoConfig(KtConfig conf) {
        config = conf;
    }

    public static KtConfig getTypoConfig() {
        return config;
    }

    public static void charWarning(KtFontMetric metric, KtCharCode code) {
        if (KtTypoCommand.getConfig().getBoolParam(BOOLP_TRACING_LOST_CHARS)) {
            diagLog.startLine().add("Missing character: There is no ").add(code).add(" in font ").add(metric.getName()).add('!').startLine();
        }
    }

    public static void appendCharsTo(KtBuilder bld, KtWordBuilder word) {
        block2: {
            KtCharCode code;
            do {
                KtToken tok;
                KtCommand cmd;
                if ((code = (cmd = KtTypoCommand.meaningOf(tok = KtTypoCommand.nextExpToken())).charCodeToAdd()) == KtCharCode.NULL) {
                    word.close(!cmd.isNoBoundary());
                    cmd.execute(tok);
                    break block2;
                }
                bld.adjustSpaceFactor(code.spaceFactor());
            } while (word.add(code));
            KtTypoCommand.charWarning(KtTypoCommand.getCurrFontMetric(), code);
        }
    }

    public static void appendChar(KtBuilder bld, KtCharCode code) {
        KtWordBuilder word = KtTypoCommand.getCurrFontMetric().getWordBuilder(APPENDER, true, bld.willBeBroken());
        bld.adjustSpaceFactor(code.spaceFactor());
        KtTypoCommand.fixLanguage(bld);
        if (word.add(code)) {
            KtTypoCommand.appendCharsTo(bld, word);
        } else {
            KtTypoCommand.charWarning(KtTypoCommand.getCurrFontMetric(), code);
        }
    }

    public static void fixLanguage(KtBuilder bld) {
        KtLanguage lang;
        if (bld.willBeBroken() && (lang = bld.getCurrLang()) != KtLanguage.NULL && KtTypoCommand.getTypoConfig().languageDiffers(lang)) {
            bld.setCurrLang(KtTypoCommand.getTypoConfig().getLanguage());
        }
    }

    public static void appendNormalSpace(KtBuilder bld) {
        KtGlue skip = KtTypoCommand.getConfig().getGlueParam(GLUEP_SPACE);
        if (skip.isZero()) {
            bld.addSkip(KtTypoCommand.getCurrFontMetric().getNormalSpace());
        } else {
            bld.addSkip(skip, KtTypoCommand.getConfig().getGlueName(GLUEP_SPACE));
        }
    }

    private static void addBoxToBuilder(KtBuilder bld, KtNode node) {
        KtDimen dim = bld.getPrevDepth();
        if (dim != KtDimen.NULL && dim.moreThan(KtVertBuilder.IGNORE_DEPTH)) {
            KtCommandBase.KtConfig cfg = KtTypoCommand.getConfig();
            KtGlue bls = cfg.getGlueParam(GLUEP_BASELINE_SKIP);
            dim = bls.getDimen().minus(dim).minus(node.getHeight());
            if (dim.lessThan(cfg.getDimParam(DIMP_LINE_SKIP_LIMIT))) {
                bld.addSkip(cfg.getGlueParam(GLUEP_LINE_SKIP), cfg.getGlueName(GLUEP_LINE_SKIP));
            } else {
                bld.addSkip(bls.resizedCopy(dim), cfg.getGlueName(GLUEP_BASELINE_SKIP));
            }
        }
        bld.addBox(node);
    }

    public static void appendBox(KtBuilder bld, KtNode box) {
        KtTypoCommand.addBoxToBuilder(bld, box);
        bld.buildPage();
    }

    public static void appendBox(KtBuilder bld, KtNode box, boolean page) {
        KtTypoCommand.addBoxToBuilder(bld, box);
        if (page) {
            bld.buildPage();
        }
    }

    public static void appendBox(KtBuilder bld, KtNode box, KtNodeEnum mig) {
        KtTypoCommand.addBoxToBuilder(bld, box);
        bld.addNodes(mig);
        bld.buildPage();
    }

    public static void appendBox(KtBuilder bld, KtNode box, KtNodeEnum mig, boolean page) {
        KtTypoCommand.addBoxToBuilder(bld, box);
        bld.addNodes(mig);
        if (page) {
            bld.buildPage();
        }
    }

    public static KtFontMetric scanFontMetric() {
        KtToken tok = KtTypoCommand.nextExpNonSpacer();
        KtCommand cmd = KtTypoCommand.meaningOf(tok);
        if (cmd.hasFontMetricValue()) {
            return cmd.getFontMetricValue();
        }
        KtTypoCommand.backToken(tok);
        KtTypoCommand.error("MissingFontIdent");
        return KtNullFontMetric.METRIC;
    }

    public static void scanBox(KtTreatBox proc) {
        KtToken tok = KtTypoCommand.nextNonRelax();
        KtCommand cmd = KtTypoCommand.meaningOf(tok);
        if (cmd.hasBoxValue()) {
            proc.execute(cmd.getBoxValue(), KtNodeList.EMPTY_ENUM);
        } else if (cmd.canMakeBoxValue()) {
            cmd.makeBoxValue(proc);
        } else {
            KtTypoCommand.backToken(tok);
            KtTypoCommand.error("BoxExpected");
        }
    }

    public static void addBoxOn(KtLog log, KtBox box) {
        int depth = KtTypoCommand.getConfig().getIntParam(INTP_SHOW_BOX_DEPTH);
        int breadth = KtTypoCommand.getConfig().getIntParam(INTP_SHOW_BOX_BREADTH);
        box.addOn(log, depth, breadth);
        log.endLine();
    }

    public static void addItemsOn(KtLog log, KtCntxLoggableEnum items) {
        int depth = KtTypoCommand.getConfig().getIntParam(INTP_SHOW_BOX_DEPTH);
        int breadth = KtTypoCommand.getConfig().getIntParam(INTP_SHOW_BOX_BREADTH);
        KtCntxLog.addItems(log, items, depth, breadth);
        log.endLine();
    }

    public static void addBoxOnDiagLog(String desc, KtBox box) {
        diagLog.startLine().add(desc);
        KtTypoCommand.addBoxOn(diagLog, box);
        diagLog.startLine().endLine();
    }

    public static void addBoxOnDiagLog(KtBox box) {
        KtTypoCommand.addBoxOn(diagLog, box);
        diagLog.startLine().endLine();
    }

    public static void addItemsOnDiagLog(String desc, KtCntxLoggableEnum items) {
        diagLog.startLine().add(desc);
        KtTypoCommand.addItemsOn(diagLog, items);
        diagLog.startLine().endLine();
    }

    public static void addItemsOnDiagLog(KtCntxLoggableEnum items) {
        KtTypoCommand.addItemsOn(diagLog, items);
        diagLog.startLine().endLine();
    }

    public static KtHBoxNode packHBox(KtNodeList list, KtDimen desired) {
        return KtTypoCommand.packHBox(list, desired, true);
    }

    public static KtHBoxNode packHBox(KtNodeList list, KtDimen desired, boolean exactly) {
        return hPacker.packHBox(list, desired, exactly);
    }

    public static KtVBoxNode packVBox(KtNodeList list, KtDimen desired) {
        return KtTypoCommand.packVBox(list, desired, true);
    }

    public static KtVBoxNode packVBox(KtNodeList list, KtDimen desired, KtDimen maxDepth) {
        return KtTypoCommand.packVBox(list, desired, true, maxDepth);
    }

    public static KtVBoxNode packVBox(KtNodeList list, KtDimen desired, boolean exactly) {
        return KtTypoCommand.packVBox(list, desired, exactly, KtDimen.NULL);
    }

    public static KtVBoxNode packVBox(KtNodeList list, KtDimen desired, boolean exactly, KtDimen maxDepth) {
        return vPacker.packVBox(list, desired, exactly, maxDepth);
    }

    public static void shipOut(KtBox box) {
        boolean tracing = KtTypoCommand.getConfig().getBoolParam(BOOLP_TRACING_OUTPUT);
        int[] nums = KtTypoCommand.getTypoConfig().currPageNumbers();
        if (tracing) {
            normLog.startLine().endLine().add("Completed box being shipped out");
        }
        normLog.sepRoom(9).add('[');
        if (nums.length > 0) {
            int i = 0;
            while (true) {
                normLog.add(nums[i++]);
                if (i >= nums.length) break;
                normLog.add('.');
            }
        }
        normLog.flush();
        if (tracing) {
            normLog.add(']');
            KtTypoCommand.addBoxOnDiagLog(box);
        }
        KtDimen hOffset = KtTypoCommand.getConfig().getDimParam(DIMP_H_OFFSET);
        KtDimen vOffset = KtTypoCommand.getConfig().getDimParam(DIMP_V_OFFSET);
        KtDimen height = box.getHeight().plus(box.getDepth());
        KtDimen width = box.getWidth().plus(box.getLeftX());
        if (box.getHeight().moreThan(KtDimen.MAX_VALUE) || box.getDepth().moreThan(KtDimen.MAX_VALUE) || vOffset.plus(height).moreThan(KtDimen.MAX_VALUE) || hOffset.plus(width).moreThan(KtDimen.MAX_VALUE)) {
            KtTypoCommand.error("PageTooLarge");
            if (!tracing) {
                KtTypoCommand.addBoxOnDiagLog("The following box has been deleted:", box);
            }
        } else {
            KtTypesetter setter = KtTypoCommand.getTypoHandler().getTypesetter();
            setter.startPage(vOffset, hOffset, height, width, nums);
            setter.moveDown(box.getHeight());
            setter.moveRight(box.getLeftX());
            box.typeSet(setter);
            setter.endPage();
        }
        if (!tracing) {
            normLog.add(']');
        }
        normLog.flush();
        KtTypoCommand.getTypoConfig().resetOutput();
    }

    static {
        BOOLP_TRACING_LOST_CHARS = KtTypoCommand.newBoolParam();
        APPENDER = new KtTreatNode(){

            @Override
            public void execute(KtNode node) {
                KtTypoCommand.getBld().addNode(node);
            }
        };
        GLUEP_SPACE = KtTypoCommand.newGlueParam();
        GLUEP_XSPACE = KtTypoCommand.newGlueParam();
        DIMP_LINE_SKIP_LIMIT = KtTypoCommand.newDimParam();
        GLUEP_LINE_SKIP = KtTypoCommand.newGlueParam();
        GLUEP_BASELINE_SKIP = KtTypoCommand.newGlueParam();
        INTP_SHOW_BOX_DEPTH = KtTypoCommand.newIntParam();
        INTP_SHOW_BOX_BREADTH = KtTypoCommand.newIntParam();
        INTP_HBADNESS = KtTypoCommand.newIntParam();
        DIMP_HFUZZ = KtTypoCommand.newDimParam();
        DIMP_OVERFULL_RULE = KtTypoCommand.newDimParam();
        INTP_VBADNESS = KtTypoCommand.newIntParam();
        DIMP_VFUZZ = KtTypoCommand.newDimParam();
        hPacker = new KtHBoxPacker();
        vPacker = new KtVBoxPacker();
        DIMP_BOX_MAX_DEPTH = KtTypoCommand.newDimParam();
        DIMP_SPLIT_MAX_DEPTH = KtTypoCommand.newDimParam();
        GLUEP_SPLIT_TOP_SKIP = KtTypoCommand.newGlueParam();
        INTP_OUTPUT_BOX_NUM = KtTypoCommand.newIntParam();
        BOOLP_TRACING_OUTPUT = KtTypoCommand.newBoolParam();
        DIMP_H_OFFSET = KtTypoCommand.newDimParam();
        DIMP_V_OFFSET = KtTypoCommand.newDimParam();
    }

    public static interface KtTypoHandler {
        public KtFontMetric getMetric(KtFileName var1, KtDimen var2, KtNum var3, KtName var4, KtLoggable var5);

        public KtFontDimen getFontDimen(KtFontMetric var1, int var2);

        public KtTypesetter getTypesetter();

        public void setTypesetter(KtTypesetter var1);
    }

    public static interface KtConfig {
        public void setLastBadness(int var1);

        public void setOutputPenalty(int var1);

        public int[] currPageNumbers();

        public void checkParagraph(KtToken var1);

        public void resetParagraph();

        public void setMarginSkipsShrinkFinite();

        public boolean activeOutput();

        public boolean pendingOutput();

        public void resetOutput();

        public KtLinesShape linesShape();

        public KtLanguage getLanguage();

        public KtLanguage getLanguage(int var1);

        public boolean languageDiffers(KtLanguage var1);

        public boolean patternsAllowed();

        public void preparePatterns();
    }

    public static class KtHBoxPacker
    extends KtAnyBoxPacker {
        public KtHBoxNode packHBox(KtNodeList list, KtDimen desired, boolean exactly) {
            KtSizesEvaluator pack = new KtSizesEvaluator();
            KtHorizIterator.summarize(list.nodes(), pack);
            KtDimen size = pack.getBody().plus(pack.getDepth());
            boolean empty = list.isEmpty();
            if (exactly) {
                pack.evaluate(desired.minus(size), empty);
                size = desired;
            } else {
                pack.evaluate(desired, empty);
                size = size.plus(desired);
            }
            KtBoxSizes sizes = new KtBoxSizes(pack.getWidth(), size, pack.getLeftX(), pack.getHeight());
            KtHBoxNode hbox = new KtHBoxNode(sizes, pack.getSetting(), list);
            if (pack.getReport() == 3) {
                this.addOverfullRule(list, pack.getOverfull());
            }
            if (this.check(pack)) {
                this.reportBox(hbox);
            }
            return hbox;
        }

        protected void addOverfullRule(KtNodeList list, KtDimen excess) {
            if (KtCommandBase.getConfig().getDimParam(DIMP_OVERFULL_RULE).moreThan(0) && KtCommandBase.getConfig().getDimParam(this.getFuzzParam()).lessThan(excess)) {
                KtBoxSizes sizes = new KtBoxSizes(KtDimen.NULL, KtCommandBase.getConfig().getDimParam(DIMP_OVERFULL_RULE), KtDimen.NULL, KtDimen.ZERO);
                list.append(new KtRuleNode(sizes));
            }
        }

        @Override
        public void reportBox(KtAnyBoxNode box) {
            if (!KtHBoxPacker.takingOverLocationReported(KtCommandBase.normLog)) {
                this.reportLocation(KtCommandBase.normLog);
            }
            KtCommandBase.normLog.endLine();
            box.addListShortlyOn(KtCommandBase.normLog);
            KtCommandBase.normLog.endLine();
            KtTypoCommand.addBoxOnDiagLog(box);
        }

        @Override
        protected String getName() {
            return "hbox";
        }

        @Override
        protected String getDim() {
            return "wide";
        }

        @Override
        protected int getBadnessParam() {
            return INTP_HBADNESS;
        }

        @Override
        protected int getFuzzParam() {
            return DIMP_HFUZZ;
        }
    }

    public static class KtVBoxPacker
    extends KtAnyBoxPacker {
        public KtVBoxNode packVBox(KtNodeList list, KtDimen desired, boolean exactly, KtDimen maxDepth) {
            KtSizesEvaluator pack = new KtSizesEvaluator();
            KtVertIterator.summarize(list.nodes(), pack);
            if (maxDepth != KtDimen.NULL) {
                pack.restrictDepth(maxDepth);
            }
            KtDimen size = pack.getBody().plus(pack.getHeight());
            boolean empty = list.isEmpty();
            if (exactly) {
                pack.evaluate(desired.minus(size), empty);
                size = desired;
            } else {
                pack.evaluate(desired, empty);
                size = size.plus(desired);
            }
            KtBoxSizes sizes = new KtBoxSizes(size, pack.getWidth(), pack.getDepth(), pack.getLeftX());
            KtVBoxNode vbox = new KtVBoxNode(sizes, pack.getSetting(), list);
            if (this.check(pack)) {
                this.reportBox(vbox);
            }
            return vbox;
        }

        @Override
        protected String getName() {
            return "vbox";
        }

        @Override
        protected String getDim() {
            return "high";
        }

        @Override
        protected int getBadnessParam() {
            return INTP_VBADNESS;
        }

        @Override
        protected int getFuzzParam() {
            return DIMP_VFUZZ;
        }
    }

    public static abstract class KtAnyBoxPacker {
        public boolean check(KtSizesEvaluator pack) {
            int badness = pack.getBadness();
            KtTypoCommand.getTypoConfig().setLastBadness(badness);
            return switch (pack.getReport()) {
                case 1 -> this.underfull(badness);
                case 2 -> this.tight(badness);
                case 3 -> this.overfull(pack.getOverfull());
                default -> false;
            };
        }

        public void reportBox(KtAnyBoxNode box) {
            if (!KtAnyBoxPacker.takingOverLocationReported(KtCommandBase.normLog)) {
                this.reportLocation(KtCommandBase.normLog);
                KtCommandBase.normLog.endLine();
            }
            KtTypoCommand.addBoxOnDiagLog(box);
        }

        protected boolean underfull(int badness) {
            if (badness > KtCommandBase.getConfig().getIntParam(this.getBadnessParam())) {
                KtCommandBase.normLog.endLine().add(badness > 100 ? "Underfull" : "Loose").add(' ').addEsc(this.getName()).add(" (badness ").add(badness).add(") ");
                return true;
            }
            return false;
        }

        protected boolean tight(int badness) {
            if (badness > KtCommandBase.getConfig().getIntParam(this.getBadnessParam())) {
                KtCommandBase.normLog.endLine().add("Tight ").addEsc(this.getName()).add(" (badness ").add(badness).add(") ");
                return true;
            }
            return false;
        }

        protected boolean overfull(KtDimen excess) {
            if (KtCommandBase.getConfig().getIntParam(this.getBadnessParam()) < 100 || KtCommandBase.getConfig().getDimParam(this.getFuzzParam()).lessThan(excess)) {
                KtCommandBase.normLog.endLine().add("Overfull ").addEsc(this.getName()).add(" (").add(excess.toString("pt")).add(" too ").add(this.getDim()).add(") ");
                return true;
            }
            return false;
        }

        protected static boolean takingOverLocationReported(KtLog log) {
            if (KtTypoCommand.getTypoConfig().activeOutput()) {
                log.add("has occurred while \\output is active");
                return true;
            }
            return false;
        }

        protected void reportLocation(KtLog log) {
            log.add("detected at line ").add(KtCommandBase.currLineNumber());
        }

        protected abstract String getName();

        protected abstract String getDim();

        protected abstract int getBadnessParam();

        protected abstract int getFuzzParam();
    }

    public static class KtVertCharHandler
    implements KtCharHandler {
        @Override
        public void handle(KtBuilder bld, KtCharCode code, KtToken src) {
            KtCommandBase.backToken(src);
            KtParagraph.start(true);
        }

        @Override
        public void handleSpace(KtBuilder bld, KtToken src) {
        }
    }

    public static class KtHorizCharHandler
    implements KtCharHandler {
        @Override
        public void handle(KtBuilder bld, KtCharCode code, KtToken src) {
            KtTypoCommand.appendChar(bld, code);
        }

        @Override
        public void handleSpace(KtBuilder bld, KtToken src) {
            int sf = bld.getSpaceFactor();
            if (sf == 1000) {
                KtTypoCommand.appendNormalSpace(bld);
            } else if (sf > 0) {
                KtDimen extra;
                KtGlue skip;
                if (sf >= 2000 && !(skip = KtCommandBase.getConfig().getGlueParam(GLUEP_XSPACE)).isZero()) {
                    bld.addSkip(skip, KtCommandBase.getConfig().getGlueName(GLUEP_XSPACE));
                    return;
                }
                skip = KtCommandBase.getConfig().getGlueParam(GLUEP_SPACE);
                if (skip.isZero()) {
                    skip = KtTypoCommand.getCurrFontMetric().getNormalSpace();
                }
                KtDimen dim = skip.getDimen();
                if (sf >= 2000 && (extra = KtTypoCommand.getCurrFontMetric().getDimenParam(6)) != KtDimen.NULL) {
                    dim = dim.plus(extra);
                }
                skip = KtGlue.valueOf(dim, skip.getStretch().times(sf, 1000), skip.getStrOrder(), skip.getShrink().times(1000, sf), skip.getShrOrder());
                bld.addSkip(skip);
            }
        }
    }

    public static interface KtFontDimen {
        public KtDimen get();

        public void set(KtDimen var1);
    }
}

