/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.command.KtPrim;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtNamedVSkipNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.node.KtVertSplit;
import com.whitemagicsoftware.keentype.node.KtVoidBoxNode;
import com.whitemagicsoftware.keentype.typo.KtFetchBoxPrim;
import com.whitemagicsoftware.keentype.typo.KtSetBoxPrim;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;

public class KtVSplitPrim
extends KtFetchBoxPrim {
    private final KtSetBoxPrim reg;
    private final KtTokenList.KtMaintainer firstMark;
    private final KtTokenList.KtMaintainer lastMark;

    public KtVSplitPrim(String name, KtSetBoxPrim reg, KtTokenList.KtMaintainer firstMark, KtTokenList.KtMaintainer lastMark) {
        super(name);
        this.reg = reg;
        this.firstMark = firstMark;
        this.lastMark = lastMark;
    }

    @Override
    public KtBox getBoxValue() {
        int idx = KtPrim.scanRegisterCode();
        if (!KtVSplitPrim.scanKeyword("to")) {
            KtVSplitPrim.error("MissingToForVsplit");
        }
        KtDimen size = KtVSplitPrim.scanDimen();
        KtBox box = this.reg.get(idx);
        this.firstMark.setToksValue(KtTokenList.EMPTY);
        this.lastMark.setToksValue(KtTokenList.EMPTY);
        if (box.isVoid()) {
            return box;
        }
        KtNodeEnum nodes = box.getVertList();
        if (nodes == KtNodeEnum.NULL) {
            KtVSplitPrim.error("SplittingNonVbox", this, KtVSplitPrim.esc("vbox"));
            return KtVoidBoxNode.BOX;
        }
        KtDimen maxDepth = KtVSplitPrim.getConfig().getDimParam(DIMP_SPLIT_MAX_DEPTH);
        KtVSplitSplit splitter = new KtVSplitSplit(nodes);
        KtNodeList head = splitter.makeSplitting(size, maxDepth);
        KtVSplitPrim.setMarks(head.nodes(), this.firstMark, this.lastMark);
        splitter.pruneTop();
        KtNodeList tail = new KtNodeList(splitter.nodes());
        box = tail.isEmpty() ? KtVoidBoxNode.BOX : KtVBoxNode.packedOf(tail);
        this.reg.foist(idx, box);
        return KtVSplitPrim.packVBox(head, size, maxDepth);
    }

    public static boolean setMarks(KtNodeEnum nodes, KtTokenList.KtMaintainer first, KtTokenList.KtMaintainer last) {
        boolean noMark = true;
        while (nodes.hasMoreNodes()) {
            KtNode node = nodes.nextNode();
            if (!node.isMark()) continue;
            if (noMark) {
                noMark = false;
                first.setToksValue(node.getMark());
            }
            last.setToksValue(node.getMark());
        }
        return !noMark;
    }

    public static KtNode makeTopAdjustment(KtDimen height, int param, KtGlue skip) {
        KtDimen dim = skip.getDimen();
        dim = dim.moreThan(height) ? dim.minus(height) : KtDimen.ZERO;
        skip = skip.resizedCopy(dim);
        return new KtNamedVSkipNode(skip, KtVSplitPrim.getConfig().getGlueName(param));
    }

    public static KtNode makeTopAdjustment(KtDimen height, int param) {
        return KtVSplitPrim.makeTopAdjustment(height, param, KtVSplitPrim.getConfig().getGlueParam(param));
    }

    protected static class KtVSplitSplit
    extends KtVertSplit {
        public KtVSplitSplit(KtNodeEnum nodes) {
            super(nodes);
        }

        @Override
        protected KtNode topAdjustment(KtDimen height) {
            return KtVSplitPrim.makeTopAdjustment(height, KtTypoCommand.GLUEP_SPLIT_TOP_SKIP);
        }
    }
}

