/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import net.jsign.bouncycastle.asn1.ASN1InputStream;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.x509.CertificateList;
import net.jsign.bouncycastle.asn1.x509.Extension;
import net.jsign.bouncycastle.asn1.x509.Extensions;
import net.jsign.bouncycastle.asn1.x509.GeneralName;
import net.jsign.bouncycastle.asn1.x509.GeneralNames;
import net.jsign.bouncycastle.asn1.x509.IssuingDistributionPoint;
import net.jsign.bouncycastle.cert.CertIOException;
import net.jsign.bouncycastle.util.Encodable;

public class X509CRLHolder
implements Serializable,
Encodable {
    private transient CertificateList x509CRL;
    private transient boolean isIndirect;
    private transient Extensions extensions;
    private transient GeneralNames issuerName;

    private static CertificateList parseStream(InputStream inputStream) throws IOException {
        try {
            ASN1Primitive aSN1Primitive = new ASN1InputStream(inputStream, true).readObject();
            if (aSN1Primitive == null) {
                throw new IOException("no content found");
            }
            return CertificateList.getInstance(aSN1Primitive);
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    private static boolean isIndirectCRL(Extensions extensions) {
        if (extensions == null) {
            return false;
        }
        Extension extension = extensions.getExtension(Extension.issuingDistributionPoint);
        return extension != null && IssuingDistributionPoint.getInstance(extension.getParsedValue()).isIndirectCRL();
    }

    public X509CRLHolder(byte[] byArray) throws IOException {
        this(X509CRLHolder.parseStream(new ByteArrayInputStream(byArray)));
    }

    public X509CRLHolder(CertificateList certificateList) {
        this.init(certificateList);
    }

    private void init(CertificateList certificateList) {
        this.x509CRL = certificateList;
        this.extensions = certificateList.getTBSCertList().getExtensions();
        this.isIndirect = X509CRLHolder.isIndirectCRL(this.extensions);
        this.issuerName = new GeneralNames(new GeneralName(certificateList.getIssuer()));
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.x509CRL.getEncoded();
    }

    public CertificateList toASN1Structure() {
        return this.x509CRL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509CRLHolder)) {
            return false;
        }
        X509CRLHolder x509CRLHolder = (X509CRLHolder)object;
        return this.x509CRL.equals(x509CRLHolder.x509CRL);
    }

    public int hashCode() {
        return this.x509CRL.hashCode();
    }
}

