/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.pqc.jcajce.provider.sphincsplus;

import java.io.IOException;
import java.security.PublicKey;
import net.jsign.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.jsign.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPublicKeyParameters;
import net.jsign.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.jsign.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import net.jsign.bouncycastle.pqc.jcajce.interfaces.SPHINCSPlusKey;
import net.jsign.bouncycastle.util.Arrays;

public class BCSPHINCSPlusPublicKey
implements PublicKey,
SPHINCSPlusKey {
    private transient SPHINCSPlusPublicKeyParameters params;

    public BCSPHINCSPlusPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (SPHINCSPlusPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSPHINCSPlusPublicKey) {
            BCSPHINCSPlusPublicKey bCSPHINCSPlusPublicKey = (BCSPHINCSPlusPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSPHINCSPlusPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS+";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }
}

