/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.spi;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.jsign.log4j.spi.ObjectThreadContextMap;
import net.jsign.log4j.spi.ReadOnlyThreadContextMap;
import net.jsign.log4j.spi.ThreadContextMap;
import net.jsign.log4j.util.PropertiesUtil;
import net.jsign.log4j.util.ReadOnlyStringMap;
import net.jsign.log4j.util.SortedArrayStringMap;
import net.jsign.log4j.util.StringMap;

class CopyOnWriteSortedArrayThreadContextMap
implements ObjectThreadContextMap,
ReadOnlyThreadContextMap {
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);
    private static volatile int initialCapacity;
    private static volatile boolean inheritableMap;
    private final ThreadLocal<StringMap> localMap = this.createThreadLocalMap();

    static void init() {
        PropertiesUtil properties = PropertiesUtil.getProperties();
        initialCapacity = properties.getIntegerProperty("log4j2.ThreadContext.initial.capacity", 16);
        inheritableMap = properties.getBooleanProperty("isThreadContextMapInheritable");
    }

    private ThreadLocal<StringMap> createThreadLocalMap() {
        if (inheritableMap) {
            return new InheritableThreadLocal<StringMap>(){

                @Override
                protected StringMap childValue(StringMap parentValue) {
                    if (parentValue == null) {
                        return null;
                    }
                    StringMap stringMap = CopyOnWriteSortedArrayThreadContextMap.this.createStringMap(parentValue);
                    stringMap.freeze();
                    return stringMap;
                }
            };
        }
        return new ThreadLocal<StringMap>();
    }

    protected StringMap createStringMap(ReadOnlyStringMap original) {
        return new SortedArrayStringMap(original);
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        StringMap map = this.localMap.get();
        return map == null ? null : Collections.unmodifiableMap(map.toMap());
    }

    public String toString() {
        StringMap map = this.localMap.get();
        return map == null ? "{}" : map.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        StringMap map = this.localMap.get();
        result = 31 * result + (map == null ? 0 : map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextMap)) {
            return false;
        }
        ThreadContextMap other = (ThreadContextMap)obj;
        Map<String, String> map = this.getImmutableMapOrNull();
        Map<String, String> otherMap = other.getImmutableMapOrNull();
        return Objects.equals(map, otherMap);
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
        CopyOnWriteSortedArrayThreadContextMap.init();
    }
}

