/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.align;

import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;

public class KtPreamble {
    public static final Entry NULL_ENTRY = null;
    public final KtGlue firstSkip;
    public final String skipName;
    public final KtToken endTemplate;
    private final Entry[] records;
    private final int loopIndex;

    public KtPreamble(KtGlue firstSkip, String skipName, KtToken endTemplate, Entry[] records, int loopIndex) {
        this.firstSkip = firstSkip;
        this.skipName = skipName;
        this.endTemplate = endTemplate;
        this.records = records;
        this.loopIndex = loopIndex;
        if (loopIndex >= records.length) {
            throw new RuntimeException("invalid KtPreamble loopIndex");
        }
    }

    public int length() {
        return this.records.length;
    }

    public boolean periodic() {
        return this.loopIndex >= 0;
    }

    public boolean hasRecord(int i) {
        return i >= 0 && (i < this.records.length || this.loopIndex >= 0);
    }

    public KtTokenList getUPart(int i) {
        Entry ent = this.getEntry(i);
        return ent != NULL_ENTRY ? ent.uPart : KtTokenList.NULL;
    }

    public KtTokenList getVPart(int i) {
        Entry ent = this.getEntry(i);
        return ent != NULL_ENTRY ? ent.vPart : KtTokenList.NULL;
    }

    public KtGlue getSkip(int i) {
        Entry ent = this.getEntry(i);
        return ent != NULL_ENTRY ? ent.skip : KtGlue.NULL;
    }

    private Entry getEntry(int i) {
        if (i >= 0) {
            if (i < this.records.length) {
                return this.records[i];
            }
            if (this.loopIndex >= 0) {
                return this.records[this.loopIndex + (i - this.loopIndex) % (this.records.length - this.loopIndex)];
            }
        }
        return NULL_ENTRY;
    }

    public static class Entry {
        private final KtTokenList uPart;
        private final KtTokenList vPart;
        private final KtGlue skip;

        public Entry(KtTokenList uPart, KtTokenList vPart, KtGlue skip) {
            this.uPart = uPart;
            this.vPart = vPart;
            this.skip = skip;
        }
    }
}

