/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.align;

import com.whitemagicsoftware.keentype.align.KtAlignment;
import com.whitemagicsoftware.keentype.align.KtAnyUnsetNode;
import com.whitemagicsoftware.keentype.align.KtVAlignBuilder;
import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.builder.KtListBuilder;
import com.whitemagicsoftware.keentype.builder.KtVBoxBuilder;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtAnyBoxNode;
import com.whitemagicsoftware.keentype.node.KtAnySkipNode;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtNamedVSkipNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtSizesSummarizer;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;
import com.whitemagicsoftware.keentype.node.KtVSkipNode;
import com.whitemagicsoftware.keentype.node.KtVertIterator;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;

public class KtVertAlignment
extends KtAlignment {
    protected final KtListBuilder builder;
    protected KtVBoxBuilder rowBuilder;
    protected KtVBoxBuilder spanBuilder;

    public KtVertAlignment(KtDimen size, boolean exactly, KtTokenList.KtInserter everyCr, KtToken frzCr, KtToken frzEndt, KtListBuilder builder) {
        super(size, exactly, everyCr, frzCr, frzEndt);
        this.builder = builder;
    }

    @Override
    protected void startNonAligned() {
        super.startNonAligned();
        KtTypoCommand.getTypoConfig().resetParagraph();
    }

    @Override
    protected void startSpan(int index) {
        super.startSpan(index);
        KtTypoCommand.getTypoConfig().resetParagraph();
    }

    @Override
    protected void pushNewRowBuilder() {
        this.rowBuilder = new KtVAlignBuilder(KtVertAlignment.currLineNumber());
        KtBuilder.push(this.rowBuilder);
    }

    @Override
    protected void pushNewSpanBuilder() {
        this.spanBuilder = new KtVBoxBuilder(KtVertAlignment.currLineNumber());
        KtBuilder.push(this.spanBuilder);
    }

    @Override
    protected void addNamedSkipToRow(KtGlue skip, String name) {
        this.rowBuilder.addNamedSkip(skip, name);
    }

    @Override
    protected KtDimen packedSpanSize(int spanCount) {
        KtNodeList list = this.spanBuilder.getList();
        KtBuilder.pop();
        this.spanBuilder = null;
        KtSizesSummarizer pack = new KtSizesSummarizer();
        KtVertIterator.summarize(list.nodes(), pack);
        KtDimen size = pack.getBody().plus(pack.getHeight()).plus(pack.getDepth());
        KtBoxSizes sizes = new KtBoxSizes(size, pack.getWidth(), KtDimen.ZERO, pack.getLeftX());
        byte strOrder = pack.maxTotalStr();
        byte shrOrder = pack.maxTotalShr();
        this.rowBuilder.addNode(new KtAnyUnsetNode(sizes, list, spanCount, pack.getTotalStr(strOrder), strOrder, pack.getTotalShr(shrOrder), shrOrder));
        return size;
    }

    @Override
    protected void packRow() {
        KtNodeList list = this.rowBuilder.getList();
        KtBuilder.pop();
        this.rowBuilder = null;
        KtTypoCommand.appendBox(this.builder, new KtAnyUnsetNode(KtVertIterator.naturalSizes(list.nodes(), KtDimen.NULL), list));
    }

    @Override
    protected KtNodeEnum getUnsetNodes() {
        return this.builder.getList().nodes();
    }

    @Override
    protected KtDimen getRelevantSize(KtBoxSizes sizes) {
        return sizes.getHeight();
    }

    @Override
    protected KtBoxSizes transformSizes(KtBoxSizes sizes, KtDimen dim) {
        return sizes.withHeight(dim);
    }

    @Override
    protected KtAnyBoxNode makeBox(KtBoxSizes sizes, KtGlueSetting setting, KtNodeList list) {
        return new KtVBoxNode(sizes, setting, list);
    }

    @Override
    protected KtAnySkipNode makeSkip(KtGlue skip) {
        return new KtVSkipNode(skip);
    }

    @Override
    protected KtAnySkipNode makeSkip(KtGlue skip, String name) {
        return new KtNamedVSkipNode(skip, name);
    }

    @Override
    protected KtTypoCommand.KtAnyBoxPacker makeBoxPacker() {
        return new KtTypoCommand.KtVBoxPacker(){

            @Override
            protected void reportLocation(KtLog log) {
                log.add("in alignment at lines ").add(KtVertAlignment.this.builder.getStartLine()).add("--").add(KtCommandBase.currLineNumber());
            }
        };
    }

    @Override
    public void copyPrevParameters(KtBuilder bld) {
        bld.setSpaceFactor(this.builder.getSpaceFactor());
    }
}

