/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import java.io.Serializable;

public final class KtBoxSizes
implements Serializable,
KtLoggable {
    public static final KtBoxSizes NULL = null;
    public static final KtBoxSizes ZERO = new KtBoxSizes(KtDimen.ZERO, KtDimen.ZERO, KtDimen.ZERO, KtDimen.ZERO);
    private final KtDimen height;
    private final KtDimen width;
    private final KtDimen depth;
    private final KtDimen leftX;

    public KtBoxSizes(KtDimen h, KtDimen w, KtDimen d, KtDimen l) {
        this.height = h;
        this.width = w;
        this.depth = d;
        this.leftX = l;
    }

    public KtDimen rawHeight() {
        return this.height;
    }

    public KtDimen rawWidth() {
        return this.width;
    }

    public KtDimen rawDepth() {
        return this.depth;
    }

    public KtDimen rawLeftX() {
        return this.leftX;
    }

    public KtDimen getHeight() {
        return KtBoxSizes.getSize(this.height);
    }

    public KtDimen getWidth() {
        return KtBoxSizes.getSize(this.width);
    }

    public KtDimen getDepth() {
        return KtBoxSizes.getSize(this.depth);
    }

    public KtDimen getLeftX() {
        return KtBoxSizes.getSize(this.leftX);
    }

    private static KtDimen getSize(KtDimen x) {
        return x != KtDimen.NULL ? x : KtDimen.ZERO;
    }

    public KtBoxSizes replenished(KtBoxSizes around) {
        KtDimen h = this.height;
        KtDimen w = this.width;
        KtDimen d = this.depth;
        KtDimen l = this.leftX;
        boolean change = false;
        if (h == KtDimen.NULL) {
            h = around.getHeight();
            change = true;
        }
        if (w == KtDimen.NULL) {
            w = around.getWidth();
            change = true;
        }
        if (d == KtDimen.NULL) {
            d = around.getDepth();
            change = true;
        }
        if (l == KtDimen.NULL) {
            l = around.getLeftX();
            change = true;
        }
        return change ? new KtBoxSizes(h, w, d, l) : this;
    }

    public KtBoxSizes shiftedUp(KtDimen shift) {
        return new KtBoxSizes(this.height != KtDimen.NULL ? this.height.plus(shift) : this.height, this.width, this.depth != KtDimen.NULL ? this.depth.minus(shift) : this.depth, this.leftX);
    }

    public KtBoxSizes shiftedLeft(KtDimen shift) {
        return new KtBoxSizes(this.height, this.width != KtDimen.NULL ? this.width.minus(shift) : this.width, this.depth, this.leftX != KtDimen.NULL ? this.leftX.plus(shift) : this.leftX);
    }

    public KtBoxSizes withHeight(KtDimen height) {
        return new KtBoxSizes(height, this.width, this.depth, this.leftX);
    }

    public KtBoxSizes withWidth(KtDimen width) {
        return new KtBoxSizes(this.height, width, this.depth, this.leftX);
    }

    public KtBoxSizes withDepth(KtDimen depth) {
        return new KtBoxSizes(this.height, this.width, depth, this.leftX);
    }

    public KtBoxSizes withLeftX(KtDimen leftX) {
        return new KtBoxSizes(this.height, this.width, this.depth, leftX);
    }

    @Override
    public void addOn(KtLog log) {
        log.add('(');
        KtBoxSizes.addSize(log, this.height);
        log.add('+');
        KtBoxSizes.addSize(log, this.depth);
        log.add(")x");
        KtBoxSizes.addSize(log, this.width);
    }

    private static void addSize(KtLog log, KtDimen x) {
        if (x == KtDimen.NULL) {
            log.add('*');
        } else {
            log.add(x.toString());
        }
    }
}

