/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.node.KtDiscretionaryNode;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtHyphens;
import com.whitemagicsoftware.keentype.node.KtInsetedNodeEnum;
import com.whitemagicsoftware.keentype.node.KtLanguage;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtTreatNode;
import com.whitemagicsoftware.keentype.node.KtWordRebuilder;

public abstract class KtHyphenNodeEnum
extends KtInsetedNodeEnum {
    private final boolean ucHyph;
    private KtLanguage currLang;
    private boolean spaceBreaking = true;
    private boolean wordBlock = false;

    public KtHyphenNodeEnum(KtNodeEnum in, KtLanguage lang, boolean ucHyph) {
        super(in);
        this.currLang = lang;
        this.ucHyph = ucHyph;
    }

    private KtNode getNextNode() {
        KtNode node = super.nextNode();
        if (node.allowsSpaceBreaking()) {
            this.spaceBreaking = true;
        } else if (node.forbidsSpaceBreaking()) {
            this.spaceBreaking = false;
        }
        KtLanguage altLang = node.alteringLanguage();
        if (altLang != KtLanguage.NULL) {
            this.currLang = altLang;
        }
        return node;
    }

    @Override
    public KtNode nextNode() {
        KtNode node;
        KtNodeList block;
        if (this.wordBlock && !(block = this.nextWordBlock()).isEmpty()) {
            this.inseted = block.nodes();
        }
        this.wordBlock = (node = this.getNextNode()).startsWordBlock() && this.spaceBreaking;
        return node;
    }

    protected KtNodeList nextWordBlock() {
        KtNode node;
        byte r;
        KtNodeList list = new KtNodeList();
        do {
            if (!this.hasMoreNodes()) {
                return list;
            }
            node = this.getNextNode();
            list.append(node);
            r = node.beforeWord();
            if (r != 0) continue;
            return list;
        } while (r != 2);
        KtName.KtBuffer word = new KtName.KtBuffer();
        KtFontMetric wordMetric = KtFontMetric.NULL;
        int beg = list.length() - 1;
        KtLanguage lang = KtLanguage.NULL;
        KtCharCode hyphCode = KtCharCode.NULL;
        int count = 0;
        while (node.canBePartOfWord()) {
            KtFontMetric metric = node.uniformMetric();
            if (metric != KtFontMetric.NULL) {
                if (wordMetric == KtFontMetric.NULL) {
                    hyphCode = this.hyphenChar(metric);
                    if (hyphCode == KtCharCode.NULL) {
                        return list;
                    }
                    wordMetric = metric;
                } else if (!metric.equals(wordMetric)) break;
            }
            node.contributeCharCodes(word);
            int cnt = word.length();
            if (cnt >= 64) break;
            count = cnt;
            lang = this.currLang;
            if (!this.hasMoreNodes()) {
                return this.hyphenated(word, count, wordMetric, lang, hyphCode, list, beg, list.length());
            }
            node = this.getNextNode();
            list.append(node);
        }
        int end = list.length() - 1;
        byte r2;
        while ((r2 = node.afterWord()) != 0) {
            if (r2 == 2 || !this.hasMoreNodes()) {
                return this.hyphenated(word, count, wordMetric, lang, hyphCode, list, beg, end);
            }
            node = this.getNextNode();
            list.append(node);
        }
        return list;
    }

    protected KtNodeList hyphenated(KtName.KtBuffer buf, int count, KtFontMetric metric, KtLanguage lang, KtCharCode hyphCode, KtNodeList list, int beg, int end) {
        if (count > 0 && metric != KtFontMetric.NULL) {
            KtCharCode[] word = new KtCharCode[count];
            buf.getCodes(0, count, word, 0);
            if (this.ucHyph || word[0].toCanonicalLetter() == word[0].toChar()) {
                char[] canon = new char[count];
                for (int i = 0; i < count; ++i) {
                    canon[i] = word[i].toCanonicalLetter();
                }
                KtHyphens hyphens = lang.getHyphens(new String(canon));
                if (!hyphens.isEmpty()) {
                    return new KtHyphenator(word, metric, hyphens, hyphCode, list, beg, end).hyphenated();
                }
            }
        }
        return list;
    }

    protected abstract KtCharCode hyphenChar(KtFontMetric var1);

    protected abstract void complain(KtFontMetric var1, KtCharCode var2);

    private class KtHyphenator {
        private final KtCharCode[] word;
        private final KtFontMetric metric;
        private final KtHyphens hyphens;
        private final KtCharCode hyphCode;
        private final KtNodeList source;
        private final int beg;
        private final int end;
        private int hyphenDone;
        private int passed;
        private KtCharCode boundary = KtCharCode.NULL;
        private boolean rightHit = false;

        public KtHyphenator(KtCharCode[] word, KtFontMetric metric, KtHyphens hyphens, KtCharCode hyphCode, KtNodeList source, int beg, int end) {
            this.word = word;
            this.metric = metric;
            this.hyphens = hyphens;
            this.hyphCode = hyphCode;
            this.source = source;
            this.beg = beg;
            this.end = end;
        }

        /*
         * Unable to fully structure code
         */
        public KtNodeList hyphenated() {
            this.findBoundary();
            result = new KtNodeList();
            result.append(this.source.nodes(0, this.replaceFrom()));
            pre = new KtAppender();
            post = new KtAppender();
            list = new KtAppender();
            n = this.word.length;
            this.hyphenDone = -1;
            j = -1;
            while (j < n) {
                l = j;
                j = this.passingReconstitute(j, n, list);
                if (this.passed < 0) {
                    result.append(list.takeList());
                    if (this.hyphenAt(j)) {
                        l = j;
                        this.passed = j;
                    }
                }
                while (this.passed >= 0) {
                    this.hyphenDone = this.passed;
                    this.hyphenReconstitute(l, this.passed, pre);
                    bound = true;
                    i = this.passed;
                    do lbl-1000:
                    // 3 sources

                    {
                        i = this.reconstitute(i, n, post, bound);
                        bound = false;
                        if (i < j) ** GOTO lbl-1000
                        while (j < i) {
                            j = this.reconstitute(j, n, list, false);
                        }
                    } while (i < j);
                    main = list.takeList();
                    if (main.length() > 127) {
                        result.append(main);
                        pre.clear();
                        post.clear();
                    } else {
                        result.append(new KtDiscretionaryNode(pre.takeList(), post.takeList(), main));
                    }
                    this.passed = this.hyphenAt(j) != false ? j : -1;
                    l = j;
                }
            }
            return result.append(this.source.nodes(this.end));
        }

        private int passingReconstitute(int j, int n, KtTreatNode proc) {
            KtWordRebuilder reb;
            if (j >= 0) {
                reb = this.metric.getWordRebuilder(proc, false);
            } else {
                j = 0;
                reb = this.firstRebuilder(proc);
            }
            this.passed = -1;
            while (true) {
                block10: {
                    block9: {
                        block8: {
                            if (this.passed < 0 && this.hyphenAt(j) && reb.prolongsCut(this.hyphCode)) {
                                this.passed = j;
                            }
                            if (j < n) break block8;
                            this.finalClose(reb);
                            break block9;
                        }
                        byte how = reb.addIfBelongsToCut(this.word[j]);
                        if (this.passed < 0 && how != 0 && this.hyphenAt(j)) {
                            this.passed = j;
                        }
                        if (how == 2) break block10;
                    }
                    return j;
                }
                ++j;
            }
        }

        private void hyphenReconstitute(int j, int n, KtTreatNode proc) {
            KtWordRebuilder reb;
            if (j >= 0) {
                reb = this.metric.getWordRebuilder(proc, false);
            } else {
                j = 0;
                reb = this.firstRebuilder(proc);
            }
            while (j < n) {
                reb.add(this.word[j++]);
            }
            if (!reb.add(this.hyphCode)) {
                KtHyphenNodeEnum.this.complain(this.metric, this.hyphCode);
            }
            reb.close(true);
        }

        private int reconstitute(int j, int n, KtTreatNode proc, boolean bound) {
            KtWordRebuilder reb = this.metric.getWordRebuilder(proc, bound);
            while (true) {
                if (j >= n) {
                    this.finalClose(reb);
                    return j;
                }
                byte code = reb.addIfBelongsToCut(this.word[j]);
                if (code != 2) {
                    return j;
                }
                ++j;
            }
        }

        private boolean hyphenAt(int pos) {
            return pos > this.hyphenDone && this.hyphens.hyphenAt(pos);
        }

        private int replaceFrom() {
            return this.beg > 0 && this.metric.equals(this.source.nodeAt(this.beg - 1).uniformMetric()) ? this.beg - 1 : this.beg;
        }

        private KtWordRebuilder firstRebuilder(KtTreatNode proc) {
            if (this.beg > 0) {
                KtFontMetric prevMetric = this.source.nodeAt(this.beg - 1).uniformMetric();
                if (prevMetric == KtFontMetric.NULL) {
                    return this.source.nodeAt(this.beg).makeRebuilder(proc, false);
                }
                if (this.metric.equals(prevMetric)) {
                    return this.source.nodeAt(this.beg - 1).makeRebuilder(proc, true);
                }
            }
            return this.metric.getWordRebuilder(proc, true);
        }

        private void findBoundary() {
            KtNode node;
            if (this.end < this.source.length() && this.metric.equals((node = this.source.nodeAt(this.end)).uniformMetric())) {
                KtName.KtBuffer buf = new KtName.KtBuffer();
                node.contributeCharCodes(buf);
                if (buf.length() > 0) {
                    this.boundary = buf.codeAt(0);
                }
            }
            if (this.boundary == KtCharCode.NULL) {
                this.rightHit = this.source.nodeAt(this.end - 1).rightBoundary();
            }
        }

        private void finalClose(KtWordRebuilder reb) {
            if (this.boundary != KtCharCode.NULL) {
                reb.close(this.boundary);
            } else {
                reb.close(this.rightHit);
            }
        }
    }

    private static class KtAppender
    implements KtTreatNode {
        private KtNodeList list = new KtNodeList();

        private KtAppender() {
        }

        @Override
        public void execute(KtNode node) {
            this.list.append(node);
        }

        public void clear() {
            if (!this.list.isEmpty()) {
                this.list = new KtNodeList();
            }
        }

        public KtNodeList takeList() {
            if (this.list.isEmpty()) {
                return KtNodeList.EMPTY;
            }
            KtNodeList curr = this.list;
            this.list = new KtNodeList();
            return curr;
        }

        public String toString() {
            return this.list.toString();
        }
    }
}

