/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.tex.KtFileFormat;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Optional;

public interface KtTypesetter {
    public static final KtTypesetter NULL = null;

    public void set(char var1, KtFontMetric var2);

    public void set(KtCharCode var1, KtFontMetric var2);

    public void setRule(KtDimen var1, KtDimen var2);

    public void setSpecial(byte[] var1);

    public void moveLeft(KtDimen var1);

    public void moveRight(KtDimen var1);

    public void moveUp(KtDimen var1);

    public void moveDown(KtDimen var1);

    public KtMark mark();

    public void syncHoriz();

    public void syncVert();

    public void push();

    public void pop();

    public void setFileName(KtFileName var1);

    public Optional<KtFileName> getFileName();

    default public void setScale(double scale) {
    }

    default public void startDocument(KtFileName fileName) {
        try {
            this.setFileName(fileName);
            KtFileName file = this.getFileName().orElse(fileName);
            this.startDocument(new FileOutputStream(file.getPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void startDocument(OutputStream var1);

    public void startPage(KtDimen var1, KtDimen var2, KtDimen var3, KtDimen var4, int[] var5);

    public int pageCount();

    public void endPage();

    public void close();

    public KtFileFormat getExtension();

    default public KtFileName addExtension(KtFileName fileName) {
        KtFileName name = fileName.copy();
        name.append('.');
        name.append(this.getExtension().toString());
        return name;
    }

    public static interface KtMark {
        public void move();

        public KtDimen xDiff();

        public KtDimen yDiff();
    }
}

