/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tfm;

import com.whitemagicsoftware.keentype.base.KtBinFraction;

public final class KtFixWord
extends KtBinFraction {
    private static final int POINT_SHIFT = 20;
    private static final int MAX_REPR_VALUE = Integer.MAX_VALUE;
    public static final KtFixWord NULL = null;
    public static final KtFixWord ZERO = KtFixWord.valueOf(0);
    public static final KtFixWord UNITY = KtFixWord.valueOf(1);
    public static final KtFixWord MAX_VALUE = new KtFixWord(Integer.MAX_VALUE);
    public static final KtFixWord BAD_VALUE = new KtFixWord(Integer.MIN_VALUE);

    private KtFixWord(int val) {
        super(val);
    }

    @Override
    protected int pointShift() {
        return 20;
    }

    private static int makeRepr(int num) {
        return num << 20;
    }

    private static int makeRepr(int num, int den) {
        return (int)(((long)num << 20) / (long)den);
    }

    private static int makeRepr(KtBinFraction x) {
        return KtFixWord.makeRepr(x, 20);
    }

    public static KtFixWord valueOf(KtFixWord d) {
        return new KtFixWord(d.value);
    }

    public static KtFixWord valueOf(int num) {
        return new KtFixWord(KtFixWord.makeRepr(num));
    }

    public static KtFixWord valueOf(int num, int den) {
        return new KtFixWord(KtFixWord.makeRepr(num, den));
    }

    public static KtFixWord valueOf(KtBinFraction x) {
        return new KtFixWord(KtFixWord.makeRepr(x));
    }

    public static KtFixWord shiftedValueOf(int num, int offs) {
        return new KtFixWord((offs += 20) < 0 ? num >> -offs : num << offs);
    }

    public static KtFixWord valueOf(String s) throws NumberFormatException {
        boolean negative;
        int pointIndex = s.indexOf(46);
        if (pointIndex < 0) {
            return new KtFixWord(KtFixWord.makeRepr(Integer.parseInt(s)));
        }
        long val = Integer.parseInt(s.substring(0, pointIndex));
        int SHIFT = 21;
        int frac = 0;
        int i = pointIndex + 21 + 1;
        if (i > s.length()) {
            i = s.length();
        }
        while (--i > pointIndex) {
            int digit = Character.digit(s.charAt(i), 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            frac = (frac + (digit << 21)) / 10;
        }
        boolean bl = negative = val < 0L;
        if (negative) {
            val = -val;
        }
        val <<= 20;
        if ((val |= (long)(frac + 1 >>> 1)) > Integer.MAX_VALUE) {
            throw new NumberFormatException(s);
        }
        return new KtFixWord(negative ? (int)(-val) : (int)val);
    }

    public int sign() {
        return Integer.compare(this.value, 0);
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public boolean equals(KtFixWord d) {
        return this.value == d.value;
    }

    public boolean equals(int num) {
        return this.value == KtFixWord.makeRepr(num);
    }

    public boolean equals(int num, int den) {
        return this.value == KtFixWord.makeRepr(num, den);
    }

    public boolean equals(KtBinFraction x) {
        return this.value == KtFixWord.makeRepr(x);
    }

    public boolean lessThan(KtFixWord d) {
        return this.value < d.value;
    }

    public boolean lessThan(int num) {
        return this.value < KtFixWord.makeRepr(num);
    }

    public boolean lessThan(int num, int den) {
        return this.value < KtFixWord.makeRepr(num, den);
    }

    public boolean lessThan(KtBinFraction x) {
        return this.value < KtFixWord.makeRepr(x);
    }

    public boolean moreThan(KtFixWord d) {
        return this.value > d.value;
    }

    public boolean moreThan(int num) {
        return this.value > KtFixWord.makeRepr(num);
    }

    public boolean moreThan(int num, int den) {
        return this.value > KtFixWord.makeRepr(num, den);
    }

    public boolean moreThan(KtBinFraction x) {
        return this.value > KtFixWord.makeRepr(x);
    }

    public KtFixWord negative() {
        return new KtFixWord(-this.value);
    }

    public KtFixWord plus(KtFixWord d) {
        return new KtFixWord(this.value + d.value);
    }

    public KtFixWord plus(int num) {
        return new KtFixWord(this.value + KtFixWord.makeRepr(num));
    }

    public KtFixWord plus(int num, int den) {
        return new KtFixWord(this.value + KtFixWord.makeRepr(num, den));
    }

    public KtFixWord plus(KtBinFraction x) {
        return new KtFixWord(this.value + KtFixWord.makeRepr(x));
    }

    public KtFixWord minus(KtFixWord d) {
        return new KtFixWord(this.value - d.value);
    }

    public KtFixWord minus(int num) {
        return new KtFixWord(this.value - KtFixWord.makeRepr(num));
    }

    public KtFixWord minus(int num, int den) {
        return new KtFixWord(this.value - KtFixWord.makeRepr(num, den));
    }

    public KtFixWord minus(KtBinFraction x) {
        return new KtFixWord(this.value - KtFixWord.makeRepr(x));
    }

    public KtFixWord times(KtFixWord d) {
        return new KtFixWord((int)((long)this.value * (long)d.value >> 20));
    }

    public KtFixWord times(int num) {
        return new KtFixWord((int)((long)this.value * (long)num));
    }

    public KtFixWord times(int num, int den) {
        return new KtFixWord((int)((long)this.value * (long)num / (long)den));
    }

    public KtFixWord times(KtBinFraction x) {
        return new KtFixWord(this.reprTimes(x));
    }

    public KtFixWord over(KtFixWord d) {
        return new KtFixWord((int)(((long)this.value << 20) / (long)d.value));
    }

    public KtFixWord over(int num) {
        return new KtFixWord((int)((long)this.value / (long)num));
    }

    public KtFixWord over(int num, int den) {
        return new KtFixWord((int)((long)this.value * (long)den / (long)num));
    }

    public KtFixWord over(KtBinFraction x) {
        return new KtFixWord(this.reprOver(x));
    }

    public KtFixWord shifted(int offs) {
        return new KtFixWord(offs < 0 ? this.value >> -offs : this.value << offs);
    }

    public int toInt() {
        return this.value >>> 20;
    }

    public int toInt(int den) {
        return (int)((long)this.value * (long)den >>> 20);
    }

    public String toString(String unit) {
        return this.toString() + unit;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int v = this.value;
        int UNITY = 0x100000;
        int MASK = 1048575;
        if (v < 0) {
            buf.append('-');
            v = -v;
        }
        buf.append(v >>> 20);
        buf.append('.');
        v = 10 * (v & 0xFFFFF) + 5;
        int delta = 10;
        do {
            if (delta > 0x100000) {
                v += 524288 - delta / 2;
            }
            buf.append(Character.forDigit(v >>> 20, 10));
        } while ((v = 10 * (v & 0xFFFFF)) > (delta *= 10));
        return buf.toString();
    }

    public int hashCode() {
        return 7660 * this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof KtFixWord)) return false;
        KtFixWord f = (KtFixWord)o;
        if (f.value != this.value) return false;
        return true;
    }
}

