/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.typo.KtTypoAssignPrim;

public class KtSpaceFactorPrim
extends KtTypoAssignPrim
implements KtNum.KtProvider {
    public static final int MIN_SPACE_FACTOR = 1;
    public static final int MAX_SPACE_FACTOR = Short.MAX_VALUE;

    public KtSpaceFactorPrim(String name) {
        super(name);
    }

    @Override
    protected void assign(KtToken src, boolean glob) {
        KtBuilder bld = KtSpaceFactorPrim.getBld();
        if (bld.getSpaceFactor() > 0) {
            KtSpaceFactorPrim.skipOptEquals();
            int sf = KtSpaceFactorPrim.scanInt();
            if (1 <= sf && sf <= Short.MAX_VALUE) {
                bld.setSpaceFactor(sf);
            } else {
                KtSpaceFactorPrim.error("BadSpaceFactor", KtSpaceFactorPrim.num(sf), KtSpaceFactorPrim.num(1), KtSpaceFactorPrim.num(Short.MAX_VALUE));
            }
        } else {
            this.illegalCase(bld);
        }
    }

    @Override
    public boolean hasCrazyValue() {
        if (KtSpaceFactorPrim.getBld().getSpaceFactor() > 0) {
            return false;
        }
        KtSpaceFactorPrim.error("ImproperSForPD", this);
        return true;
    }

    @Override
    public boolean hasDimenValue() {
        return KtSpaceFactorPrim.getBld().getSpaceFactor() <= 0;
    }

    @Override
    public KtDimen getDimenValue() {
        int sf = KtSpaceFactorPrim.getBld().getSpaceFactor();
        if (sf > 0) {
            return KtDimen.NULL;
        }
        KtSpaceFactorPrim.error("ImproperSForPD", this);
        return KtDimen.ZERO;
    }

    @Override
    public boolean hasNumValue() {
        return true;
    }

    @Override
    public KtNum getNumValue() {
        int sf = KtSpaceFactorPrim.getBld().getSpaceFactor();
        if (sf > 0) {
            return KtNum.valueOf(sf);
        }
        KtSpaceFactorPrim.error("ImproperSForPD", this);
        return KtNum.ZERO;
    }
}

