package info.bliki.api;

import org.xml.sax.SAXException;
import org.xml.sax.Attributes;

/**
 * Reads <code>Parse</code> data from an XML file generated by the <a href="http://meta.wikimedia.org/w/api.php">Wikimedia API</a>
 * TODO: this class is not finished yet
 */
public class XMLParseParser extends AbstractXMLParser{

    private static final String PARSE_TAG = "parse";
    private static final String TEXT_TAG = "text";
    private static final String DISPLAY_TITLE_ATTR = "displaytitle";

    private ParseData parse;

    public XMLParseParser(String xmlText) throws SAXException {
        super(xmlText);
        parse = new ParseData();
    }

    public ParseData getParse() {
        return parse;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        fAttributes = attributes;

        if (PARSE_TAG.equalsIgnoreCase(qName)) {
            parse.setDisplaytitle(fAttributes.getValue(DISPLAY_TITLE_ATTR));            
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TEXT_TAG.equalsIgnoreCase(qName)) {
            parse.setText(getString());
        }
        fData = null;
        fAttributes = null;
    }
}
